# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_product_description import AwsProductDescription
from suger_sdk_python.models.aws_product_dimension import AwsProductDimension
from suger_sdk_python.models.aws_product_promotional_resources import AwsProductPromotionalResources
from suger_sdk_python.models.aws_product_repository import AwsProductRepository
from suger_sdk_python.models.aws_product_signature_verification_key import AwsProductSignatureVerificationKey
from suger_sdk_python.models.aws_product_support_information import AwsProductSupportInformation
from suger_sdk_python.models.aws_product_version import AwsProductVersion
from typing import Optional, Set
from typing_extensions import Self

class AwsProduct(BaseModel):
    """
    AwsProduct
    """ # noqa: E501
    description: Optional[AwsProductDescription] = Field(default=None, alias="Description")
    dimensions: Optional[List[AwsProductDimension]] = Field(default=None, alias="Dimensions")
    promotional_resources: Optional[AwsProductPromotionalResources] = Field(default=None, alias="PromotionalResources")
    repositories: Optional[List[AwsProductRepository]] = Field(default=None, alias="Repositories")
    signature_verification_keys: Optional[List[AwsProductSignatureVerificationKey]] = Field(default=None, alias="SignatureVerificationKeys")
    support_information: Optional[AwsProductSupportInformation] = Field(default=None, alias="SupportInformation")
    versions: Optional[List[AwsProductVersion]] = Field(default=None, alias="Versions")
    data_feed_product_id: Optional[StrictStr] = Field(default=None, description="The product Id in AWS Marketplace Data Feed Service.", alias="dataFeedProductId")
    product_id: Optional[StrictStr] = Field(default=None, description="AWS Product ID", alias="productId")
    __properties: ClassVar[List[str]] = ["Description", "Dimensions", "PromotionalResources", "Repositories", "SignatureVerificationKeys", "SupportInformation", "Versions", "dataFeedProductId", "productId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsProduct from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['Description'] = self.description.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dimensions (list)
        _items = []
        if self.dimensions:
            for _item_dimensions in self.dimensions:
                if _item_dimensions:
                    _items.append(_item_dimensions.to_dict())
            _dict['Dimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of promotional_resources
        if self.promotional_resources:
            _dict['PromotionalResources'] = self.promotional_resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in repositories (list)
        _items = []
        if self.repositories:
            for _item_repositories in self.repositories:
                if _item_repositories:
                    _items.append(_item_repositories.to_dict())
            _dict['Repositories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in signature_verification_keys (list)
        _items = []
        if self.signature_verification_keys:
            for _item_signature_verification_keys in self.signature_verification_keys:
                if _item_signature_verification_keys:
                    _items.append(_item_signature_verification_keys.to_dict())
            _dict['SignatureVerificationKeys'] = _items
        # override the default output from pydantic by calling `to_dict()` of support_information
        if self.support_information:
            _dict['SupportInformation'] = self.support_information.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in versions (list)
        _items = []
        if self.versions:
            for _item_versions in self.versions:
                if _item_versions:
                    _items.append(_item_versions.to_dict())
            _dict['Versions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsProduct from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Description": AwsProductDescription.from_dict(obj["Description"]) if obj.get("Description") is not None else None,
            "Dimensions": [AwsProductDimension.from_dict(_item) for _item in obj["Dimensions"]] if obj.get("Dimensions") is not None else None,
            "PromotionalResources": AwsProductPromotionalResources.from_dict(obj["PromotionalResources"]) if obj.get("PromotionalResources") is not None else None,
            "Repositories": [AwsProductRepository.from_dict(_item) for _item in obj["Repositories"]] if obj.get("Repositories") is not None else None,
            "SignatureVerificationKeys": [AwsProductSignatureVerificationKey.from_dict(_item) for _item in obj["SignatureVerificationKeys"]] if obj.get("SignatureVerificationKeys") is not None else None,
            "SupportInformation": AwsProductSupportInformation.from_dict(obj["SupportInformation"]) if obj.get("SupportInformation") is not None else None,
            "Versions": [AwsProductVersion.from_dict(_item) for _item in obj["Versions"]] if obj.get("Versions") is not None else None,
            "dataFeedProductId": obj.get("dataFeedProductId"),
            "productId": obj.get("productId")
        })
        return _obj


