# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AwsProductDeliveryOption(BaseModel):
    """
    AwsProductDeliveryOption
    """ # noqa: E501
    ami_alias: Optional[StrictStr] = Field(default=None, description="Exclusive Fields For AWS AMI Product", alias="AmiAlias")
    fulfillment_url: Optional[StrictStr] = Field(default=None, description="Exclusive Fields For AWS SaaS Product", alias="FulfillmentUrl")
    id: Optional[StrictStr] = Field(default=None, alias="Id")
    recommendations: Optional[Dict[str, Any]] = Field(default=None, alias="Recommendations")
    short_description: Optional[StrictStr] = Field(default=None, alias="ShortDescription")
    source_id: Optional[StrictStr] = Field(default=None, alias="SourceId")
    title: Optional[StrictStr] = Field(default=None, description="Exclusive Fields For AWS Container Product", alias="Title")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    visibility: Optional[StrictStr] = Field(default=None, alias="Visibility")
    __properties: ClassVar[List[str]] = ["AmiAlias", "FulfillmentUrl", "Id", "Recommendations", "ShortDescription", "SourceId", "Title", "Type", "Visibility"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsProductDeliveryOption from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsProductDeliveryOption from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AmiAlias": obj.get("AmiAlias"),
            "FulfillmentUrl": obj.get("FulfillmentUrl"),
            "Id": obj.get("Id"),
            "Recommendations": obj.get("Recommendations"),
            "ShortDescription": obj.get("ShortDescription"),
            "SourceId": obj.get("SourceId"),
            "Title": obj.get("Title"),
            "Type": obj.get("Type"),
            "Visibility": obj.get("Visibility")
        })
        return _obj


