# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_marketplace_product_visibility import AwsMarketplaceProductVisibility
from typing import Optional, Set
from typing_extensions import Self

class AwsProductDescription(BaseModel):
    """
    AwsProductDescription
    """ # noqa: E501
    associated_products: Optional[Dict[str, Any]] = Field(default=None, alias="AssociatedProducts")
    categories: Optional[List[StrictStr]] = Field(default=None, alias="Categories")
    eu_w8_submitted: Optional[StrictBool] = Field(default=None, alias="EuW8Submitted")
    highlights: Optional[List[StrictStr]] = Field(default=None, alias="Highlights")
    long_description: Optional[StrictStr] = Field(default=None, alias="LongDescription")
    manufacturer: Optional[StrictStr] = Field(default=None, alias="Manufacturer")
    product_code: Optional[StrictStr] = Field(default=None, alias="ProductCode")
    product_title: Optional[StrictStr] = Field(default=None, alias="ProductTitle")
    registered: Optional[StrictBool] = Field(default=None, alias="Registered")
    search_keywords: Optional[List[StrictStr]] = Field(default=None, alias="SearchKeywords")
    short_description: Optional[StrictStr] = Field(default=None, alias="ShortDescription")
    sku: Optional[StrictStr] = Field(default=None, alias="Sku")
    us_w9_submitted: Optional[StrictBool] = Field(default=None, alias="UsW9Submitted")
    visibility: Optional[AwsMarketplaceProductVisibility] = Field(default=None, alias="Visibility")
    __properties: ClassVar[List[str]] = ["AssociatedProducts", "Categories", "EuW8Submitted", "Highlights", "LongDescription", "Manufacturer", "ProductCode", "ProductTitle", "Registered", "SearchKeywords", "ShortDescription", "Sku", "UsW9Submitted", "Visibility"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsProductDescription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsProductDescription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AssociatedProducts": obj.get("AssociatedProducts"),
            "Categories": obj.get("Categories"),
            "EuW8Submitted": obj.get("EuW8Submitted"),
            "Highlights": obj.get("Highlights"),
            "LongDescription": obj.get("LongDescription"),
            "Manufacturer": obj.get("Manufacturer"),
            "ProductCode": obj.get("ProductCode"),
            "ProductTitle": obj.get("ProductTitle"),
            "Registered": obj.get("Registered"),
            "SearchKeywords": obj.get("SearchKeywords"),
            "ShortDescription": obj.get("ShortDescription"),
            "Sku": obj.get("Sku"),
            "UsW9Submitted": obj.get("UsW9Submitted"),
            "Visibility": obj.get("Visibility")
        })
        return _obj


