# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.time_unit import TimeUnit
from typing import Optional, Set
from typing_extensions import Self

class AwsProductDimension(BaseModel):
    """
    AwsProductDimension
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, alias="Description")
    key: Optional[StrictStr] = Field(default=None, alias="Key")
    length: Optional[StrictInt] = Field(default=None, description="The term length for the commit amount, such as 6 months, or 1 year. The length is used together with timeUnit. Length and TimeUnit are only used for commit dimension.", alias="Length")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Below three fields are only used for pass data when create or update product's public offer pricing. Rate is only used for update public offer, becasue rate will be set as 0.01 when create new product.", alias="Rate")
    time_unit: Optional[TimeUnit] = Field(default=None, alias="TimeUnit")
    types: Optional[List[StrictStr]] = Field(default=None, alias="Types")
    unit: Optional[StrictStr] = Field(default=None, alias="Unit")
    __properties: ClassVar[List[str]] = ["Description", "Key", "Length", "Name", "Rate", "TimeUnit", "Types", "Unit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsProductDimension from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsProductDimension from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Description": obj.get("Description"),
            "Key": obj.get("Key"),
            "Length": obj.get("Length"),
            "Name": obj.get("Name"),
            "Rate": obj.get("Rate"),
            "TimeUnit": obj.get("TimeUnit"),
            "Types": obj.get("Types"),
            "Unit": obj.get("Unit")
        })
        return _obj


