# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_product_additional_resource import AwsProductAdditionalResource
from typing import Optional, Set
from typing_extensions import Self

class AwsProductPromotionalResources(BaseModel):
    """
    AwsProductPromotionalResources
    """ # noqa: E501
    additional_resources: Optional[List[AwsProductAdditionalResource]] = Field(default=None, alias="AdditionalResources")
    logo_url: Optional[StrictStr] = Field(default=None, alias="LogoUrl")
    video_urls: Optional[List[StrictStr]] = Field(default=None, description="Currently, AWS only support 1 url in the array.", alias="VideoUrls")
    __properties: ClassVar[List[str]] = ["AdditionalResources", "LogoUrl", "VideoUrls"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsProductPromotionalResources from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in additional_resources (list)
        _items = []
        if self.additional_resources:
            for _item_additional_resources in self.additional_resources:
                if _item_additional_resources:
                    _items.append(_item_additional_resources.to_dict())
            _dict['AdditionalResources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsProductPromotionalResources from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AdditionalResources": [AwsProductAdditionalResource.from_dict(_item) for _item in obj["AdditionalResources"]] if obj.get("AdditionalResources") is not None else None,
            "LogoUrl": obj.get("LogoUrl"),
            "VideoUrls": obj.get("VideoUrls")
        })
        return _obj


