# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_marketplace_contact import AzureMarketplaceContact
from suger_sdk_python.models.azure_marketplace_general_link import AzureMarketplaceGeneralLink
from suger_sdk_python.models.azure_marketplace_resource_lifecycle_state import AzureMarketplaceResourceLifecycleState
from suger_sdk_python.models.azure_marketplace_validation import AzureMarketplaceValidation
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplaceListing(BaseModel):
    """
    AzureMarketplaceListing
    """ # noqa: E501
    var_schema: Optional[StrictStr] = Field(default=None, alias="$schema")
    cloud_solution_provider_contact: Optional[AzureMarketplaceContact] = Field(default=None, alias="cloudSolutionProviderContact")
    cloud_solution_provider_marketing_materials: Optional[StrictStr] = Field(default=None, alias="cloudSolutionProviderMarketingMaterials")
    description: Optional[StrictStr] = None
    engineering_contact: Optional[AzureMarketplaceContact] = Field(default=None, alias="engineeringContact")
    general_links: Optional[List[AzureMarketplaceGeneralLink]] = Field(default=None, alias="generalLinks")
    getting_started_instructions: Optional[StrictStr] = Field(default=None, alias="gettingStartedInstructions")
    gloabal_support_website: Optional[StrictStr] = Field(default=None, alias="gloabalSupportWebsite")
    government_support_website: Optional[StrictStr] = Field(default=None, alias="governmentSupportWebsite")
    id: Optional[StrictStr] = None
    kind: Optional[StrictStr] = None
    language_id: Optional[StrictStr] = Field(default=None, alias="languageId")
    lifecycle_state: Optional[AzureMarketplaceResourceLifecycleState] = Field(default=None, description="Default value is \"generallyAvailable\".", alias="lifecycleState")
    privacy_policy_link: Optional[StrictStr] = Field(default=None, alias="privacyPolicyLink")
    product: Optional[StrictStr] = Field(default=None, description="Product resource name, in format of \"product/product-durable-id\"")
    resource_name: Optional[StrictStr] = Field(default=None, alias="resourceName")
    search_keywords: Optional[List[StrictStr]] = Field(default=None, alias="searchKeywords")
    search_result_summary: Optional[StrictStr] = Field(default=None, alias="searchResultSummary")
    short_description: Optional[StrictStr] = Field(default=None, alias="shortDescription")
    support_contact: Optional[AzureMarketplaceContact] = Field(default=None, alias="supportContact")
    title: Optional[StrictStr] = Field(default=None, description="Max string length is 200.")
    validations: Optional[List[AzureMarketplaceValidation]] = None
    __properties: ClassVar[List[str]] = ["$schema", "cloudSolutionProviderContact", "cloudSolutionProviderMarketingMaterials", "description", "engineeringContact", "generalLinks", "gettingStartedInstructions", "gloabalSupportWebsite", "governmentSupportWebsite", "id", "kind", "languageId", "lifecycleState", "privacyPolicyLink", "product", "resourceName", "searchKeywords", "searchResultSummary", "shortDescription", "supportContact", "title", "validations"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['azureSaaS', 'azureVM', 'xbox360NonBackCompat']):
            raise ValueError("must be one of enum values ('azureSaaS', 'azureVM', 'xbox360NonBackCompat')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplaceListing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud_solution_provider_contact
        if self.cloud_solution_provider_contact:
            _dict['cloudSolutionProviderContact'] = self.cloud_solution_provider_contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of engineering_contact
        if self.engineering_contact:
            _dict['engineeringContact'] = self.engineering_contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in general_links (list)
        _items = []
        if self.general_links:
            for _item_general_links in self.general_links:
                if _item_general_links:
                    _items.append(_item_general_links.to_dict())
            _dict['generalLinks'] = _items
        # override the default output from pydantic by calling `to_dict()` of support_contact
        if self.support_contact:
            _dict['supportContact'] = self.support_contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in validations (list)
        _items = []
        if self.validations:
            for _item_validations in self.validations:
                if _item_validations:
                    _items.append(_item_validations.to_dict())
            _dict['validations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplaceListing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "$schema": obj.get("$schema"),
            "cloudSolutionProviderContact": AzureMarketplaceContact.from_dict(obj["cloudSolutionProviderContact"]) if obj.get("cloudSolutionProviderContact") is not None else None,
            "cloudSolutionProviderMarketingMaterials": obj.get("cloudSolutionProviderMarketingMaterials"),
            "description": obj.get("description"),
            "engineeringContact": AzureMarketplaceContact.from_dict(obj["engineeringContact"]) if obj.get("engineeringContact") is not None else None,
            "generalLinks": [AzureMarketplaceGeneralLink.from_dict(_item) for _item in obj["generalLinks"]] if obj.get("generalLinks") is not None else None,
            "gettingStartedInstructions": obj.get("gettingStartedInstructions"),
            "gloabalSupportWebsite": obj.get("gloabalSupportWebsite"),
            "governmentSupportWebsite": obj.get("governmentSupportWebsite"),
            "id": obj.get("id"),
            "kind": obj.get("kind"),
            "languageId": obj.get("languageId"),
            "lifecycleState": obj.get("lifecycleState"),
            "privacyPolicyLink": obj.get("privacyPolicyLink"),
            "product": obj.get("product"),
            "resourceName": obj.get("resourceName"),
            "searchKeywords": obj.get("searchKeywords"),
            "searchResultSummary": obj.get("searchResultSummary"),
            "shortDescription": obj.get("shortDescription"),
            "supportContact": AzureMarketplaceContact.from_dict(obj["supportContact"]) if obj.get("supportContact") is not None else None,
            "title": obj.get("title"),
            "validations": [AzureMarketplaceValidation.from_dict(_item) for _item in obj["validations"]] if obj.get("validations") is not None else None
        })
        return _obj


