# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_marketplace_deprecation_schedule import AzureMarketplaceDeprecationSchedule
from suger_sdk_python.models.azure_marketplace_government_certification import AzureMarketplaceGovernmentCertification
from suger_sdk_python.models.azure_marketplace_identity import AzureMarketplaceIdentity
from suger_sdk_python.models.azure_marketplace_resource_lifecycle_state import AzureMarketplaceResourceLifecycleState
from suger_sdk_python.models.azure_marketplace_validation import AzureMarketplaceValidation
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplacePlan(BaseModel):
    """
    AzureMarketplacePlan
    """ # noqa: E501
    var_schema: Optional[StrictStr] = Field(default=None, alias="$schema")
    alias: Optional[StrictStr] = None
    azure_government_certifications: Optional[List[AzureMarketplaceGovernmentCertification]] = Field(default=None, alias="azureGovernmentCertifications")
    azure_regions: Optional[List[StrictStr]] = Field(default=None, description="enums:[azureGlobal,azureGovernment,azureGermany,azureChina]", alias="azureRegions")
    deprecation_schedule: Optional[AzureMarketplaceDeprecationSchedule] = Field(default=None, alias="deprecationSchedule")
    display_rank: Optional[StrictInt] = Field(default=None, description="default 2147483647", alias="displayRank")
    id: Optional[StrictStr] = Field(default=None, description="in format of \"plan/product-durable-id/plan-durable-id\"")
    identity: Optional[AzureMarketplaceIdentity] = None
    lifecycle_state: Optional[AzureMarketplaceResourceLifecycleState] = Field(default=None, alias="lifecycleState")
    product: Optional[StrictStr] = Field(default=None, description="in format of \"product/product-durable-id\"")
    resource_name: Optional[StrictStr] = Field(default=None, alias="resourceName")
    subtype: Optional[StrictStr] = Field(default=None, description="Specifies the plan type (AzureApplication-type products only) see: https://go.microsoft.com/fwlink/?linkid=2106322")
    validations: Optional[List[AzureMarketplaceValidation]] = None
    __properties: ClassVar[List[str]] = ["$schema", "alias", "azureGovernmentCertifications", "azureRegions", "deprecationSchedule", "displayRank", "id", "identity", "lifecycleState", "product", "resourceName", "subtype", "validations"]

    @field_validator('subtype')
    def subtype_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['managedApplication', 'solutionTemplate']):
            raise ValueError("must be one of enum values ('managedApplication', 'solutionTemplate')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplacePlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in azure_government_certifications (list)
        _items = []
        if self.azure_government_certifications:
            for _item_azure_government_certifications in self.azure_government_certifications:
                if _item_azure_government_certifications:
                    _items.append(_item_azure_government_certifications.to_dict())
            _dict['azureGovernmentCertifications'] = _items
        # override the default output from pydantic by calling `to_dict()` of deprecation_schedule
        if self.deprecation_schedule:
            _dict['deprecationSchedule'] = self.deprecation_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of identity
        if self.identity:
            _dict['identity'] = self.identity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in validations (list)
        _items = []
        if self.validations:
            for _item_validations in self.validations:
                if _item_validations:
                    _items.append(_item_validations.to_dict())
            _dict['validations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplacePlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "$schema": obj.get("$schema"),
            "alias": obj.get("alias"),
            "azureGovernmentCertifications": [AzureMarketplaceGovernmentCertification.from_dict(_item) for _item in obj["azureGovernmentCertifications"]] if obj.get("azureGovernmentCertifications") is not None else None,
            "azureRegions": obj.get("azureRegions"),
            "deprecationSchedule": AzureMarketplaceDeprecationSchedule.from_dict(obj["deprecationSchedule"]) if obj.get("deprecationSchedule") is not None else None,
            "displayRank": obj.get("displayRank"),
            "id": obj.get("id"),
            "identity": AzureMarketplaceIdentity.from_dict(obj["identity"]) if obj.get("identity") is not None else None,
            "lifecycleState": obj.get("lifecycleState"),
            "product": obj.get("product"),
            "resourceName": obj.get("resourceName"),
            "subtype": obj.get("subtype"),
            "validations": [AzureMarketplaceValidation.from_dict(_item) for _item in obj["validations"]] if obj.get("validations") is not None else None
        })
        return _obj


