# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_marketplace_price_and_availability_custom_meter_price_meter_item import AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItem
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplacePriceAndAvailabilityCustomMeterPrice(BaseModel):
    """
    AzureMarketplacePriceAndAvailabilityCustomMeterPrice
    """ # noqa: E501
    meters: Optional[Dict[str, AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItem]] = None
    price_input_option: Optional[StrictStr] = Field(default=None, description="default \"usd\"", alias="priceInputOption")
    __properties: ClassVar[List[str]] = ["meters", "priceInputOption"]

    @field_validator('price_input_option')
    def price_input_option_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['perMarket', 'usd']):
            raise ValueError("must be one of enum values ('perMarket', 'usd')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplacePriceAndAvailabilityCustomMeterPrice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in meters (dict)
        _field_dict = {}
        if self.meters:
            for _key_meters in self.meters:
                if self.meters[_key_meters]:
                    _field_dict[_key_meters] = self.meters[_key_meters].to_dict()
            _dict['meters'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplacePriceAndAvailabilityCustomMeterPrice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "meters": dict(
                (_k, AzureMarketplacePriceAndAvailabilityCustomMeterPriceMeterItem.from_dict(_v))
                for _k, _v in obj["meters"].items()
            )
            if obj.get("meters") is not None
            else None,
            "priceInputOption": obj.get("priceInputOption")
        })
        return _obj


