# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_marketplace_price_and_availability_audience import AzureMarketplacePriceAndAvailabilityAudience
from suger_sdk_python.models.azure_marketplace_price_and_availability_price import AzureMarketplacePriceAndAvailabilityPrice
from suger_sdk_python.models.azure_marketplace_price_and_availability_software_reservation import AzureMarketplacePriceAndAvailabilitySoftwareReservation
from suger_sdk_python.models.azure_marketplace_term import AzureMarketplaceTerm
from suger_sdk_python.models.azure_marketplace_validation import AzureMarketplaceValidation
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplacePriceAndAvailabilityPlan(BaseModel):
    """
    AzureMarketplacePriceAndAvailabilityPlan
    """ # noqa: E501
    var_schema: Optional[StrictStr] = Field(default=None, alias="$schema")
    audience: Optional[StrictStr] = None
    billing_tag: Optional[StrictStr] = Field(default=None, alias="billingTag")
    id: Optional[StrictStr] = None
    markets: Optional[List[StrictStr]] = None
    meter_define: Optional[StrictStr] = Field(default=None, alias="meterDefine")
    plan: Optional[StrictStr] = None
    pricing: Optional[AzureMarketplacePriceAndAvailabilityPrice] = None
    private_audiences: Optional[List[AzureMarketplacePriceAndAvailabilityAudience]] = Field(default=None, alias="privateAudiences")
    product: Optional[StrictStr] = None
    resource_name: Optional[StrictStr] = Field(default=None, alias="resourceName")
    software_reservation: Optional[List[AzureMarketplacePriceAndAvailabilitySoftwareReservation]] = Field(default=None, alias="softwareReservation")
    trial: Optional[AzureMarketplaceTerm] = None
    validations: Optional[List[AzureMarketplaceValidation]] = None
    visibility: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["$schema", "audience", "billingTag", "id", "markets", "meterDefine", "plan", "pricing", "privateAudiences", "product", "resourceName", "softwareReservation", "trial", "validations", "visibility"]

    @field_validator('audience')
    def audience_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private']):
            raise ValueError("must be one of enum values ('public', 'private')")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['visible', 'hidden']):
            raise ValueError("must be one of enum values ('visible', 'hidden')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplacePriceAndAvailabilityPlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pricing
        if self.pricing:
            _dict['pricing'] = self.pricing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in private_audiences (list)
        _items = []
        if self.private_audiences:
            for _item_private_audiences in self.private_audiences:
                if _item_private_audiences:
                    _items.append(_item_private_audiences.to_dict())
            _dict['privateAudiences'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in software_reservation (list)
        _items = []
        if self.software_reservation:
            for _item_software_reservation in self.software_reservation:
                if _item_software_reservation:
                    _items.append(_item_software_reservation.to_dict())
            _dict['softwareReservation'] = _items
        # override the default output from pydantic by calling `to_dict()` of trial
        if self.trial:
            _dict['trial'] = self.trial.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in validations (list)
        _items = []
        if self.validations:
            for _item_validations in self.validations:
                if _item_validations:
                    _items.append(_item_validations.to_dict())
            _dict['validations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplacePriceAndAvailabilityPlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "$schema": obj.get("$schema"),
            "audience": obj.get("audience"),
            "billingTag": obj.get("billingTag"),
            "id": obj.get("id"),
            "markets": obj.get("markets"),
            "meterDefine": obj.get("meterDefine"),
            "plan": obj.get("plan"),
            "pricing": AzureMarketplacePriceAndAvailabilityPrice.from_dict(obj["pricing"]) if obj.get("pricing") is not None else None,
            "privateAudiences": [AzureMarketplacePriceAndAvailabilityAudience.from_dict(_item) for _item in obj["privateAudiences"]] if obj.get("privateAudiences") is not None else None,
            "product": obj.get("product"),
            "resourceName": obj.get("resourceName"),
            "softwareReservation": [AzureMarketplacePriceAndAvailabilitySoftwareReservation.from_dict(_item) for _item in obj["softwareReservation"]] if obj.get("softwareReservation") is not None else None,
            "trial": AzureMarketplaceTerm.from_dict(obj["trial"]) if obj.get("trial") is not None else None,
            "validations": [AzureMarketplaceValidation.from_dict(_item) for _item in obj["validations"]] if obj.get("validations") is not None else None,
            "visibility": obj.get("visibility")
        })
        return _obj


