# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_marketplace_price_and_availability_recurrent_price_item import AzureMarketplacePriceAndAvailabilityRecurrentPriceItem
from suger_sdk_python.models.azure_marketplace_price_and_availability_recurrent_price_user_limit import AzureMarketplacePriceAndAvailabilityRecurrentPriceUserLimit
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplacePriceAndAvailabilityRecurrentPrice(BaseModel):
    """
    AzureMarketplacePriceAndAvailabilityRecurrentPrice
    """ # noqa: E501
    price_input_option: Optional[StrictStr] = Field(default=None, description="default \"usd\"", alias="priceInputOption")
    prices: Optional[List[AzureMarketplacePriceAndAvailabilityRecurrentPriceItem]] = None
    recurrent_price_mode: Optional[StrictStr] = Field(default=None, description="default \"flatRate\"", alias="recurrentPriceMode")
    user_limits: Optional[AzureMarketplacePriceAndAvailabilityRecurrentPriceUserLimit] = Field(default=None, alias="userLimits")
    __properties: ClassVar[List[str]] = ["priceInputOption", "prices", "recurrentPriceMode", "userLimits"]

    @field_validator('price_input_option')
    def price_input_option_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['perMarket', 'usd']):
            raise ValueError("must be one of enum values ('perMarket', 'usd')")
        return value

    @field_validator('recurrent_price_mode')
    def recurrent_price_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['flatRate', 'perUser']):
            raise ValueError("must be one of enum values ('flatRate', 'perUser')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplacePriceAndAvailabilityRecurrentPrice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prices (list)
        _items = []
        if self.prices:
            for _item_prices in self.prices:
                if _item_prices:
                    _items.append(_item_prices.to_dict())
            _dict['prices'] = _items
        # override the default output from pydantic by calling `to_dict()` of user_limits
        if self.user_limits:
            _dict['userLimits'] = self.user_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplacePriceAndAvailabilityRecurrentPrice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "priceInputOption": obj.get("priceInputOption"),
            "prices": [AzureMarketplacePriceAndAvailabilityRecurrentPriceItem.from_dict(_item) for _item in obj["prices"]] if obj.get("prices") is not None else None,
            "recurrentPriceMode": obj.get("recurrentPriceMode"),
            "userLimits": AzureMarketplacePriceAndAvailabilityRecurrentPriceUserLimit.from_dict(obj["userLimits"]) if obj.get("userLimits") is not None else None
        })
        return _obj


