# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.azure_marketplace_price_and_availability_private_offer_plan import AzureMarketplacePriceAndAvailabilityPrivateOfferPlan
from suger_sdk_python.models.azure_marketplace_private_offer_pricing_new_plan_details import AzureMarketplacePrivateOfferPricingNewPlanDetails
from suger_sdk_python.models.private_offer_discount_type import PrivateOfferDiscountType
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplacePrivateOfferPricing(BaseModel):
    """
    AzureMarketplacePrivateOfferPricing
    """ # noqa: E501
    base_plan: Optional[StrictStr] = Field(default=None, description="required for SaasNewCustomizedPlans", alias="basePlan")
    discount_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="between 0.01 to 100", alias="discountPercentage")
    discount_type: Optional[PrivateOfferDiscountType] = Field(default=None, alias="discountType")
    markup_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="between 0.00000001 to 100", alias="markupPercentage")
    new_plan_details: Optional[AzureMarketplacePrivateOfferPricingNewPlanDetails] = Field(default=None, description="required for SaasNewCustomizedPlans", alias="newPlanDetails")
    original_plan: Optional[AzureMarketplacePriceAndAvailabilityPrivateOfferPlan] = Field(default=None, description="the pricing plan of the original plan.", alias="originalPlan")
    plan: Optional[StrictStr] = Field(default=None, description="The base/original/default plan of the private offer, in format of \"plan/product-durable-id/plan-durable-id\"")
    plan_id: Optional[StrictStr] = Field(default=None, alias="planId")
    plan_name: Optional[StrictStr] = Field(default=None, alias="planName")
    plan_type: Optional[StrictStr] = Field(default=None, description="The type of the plan, FLAT_RATE or PER_USER.", alias="planType")
    price_details: Optional[Dict[str, Any]] = Field(default=None, alias="priceDetails")
    private_offer_plan: Optional[AzureMarketplacePriceAndAvailabilityPrivateOfferPlan] = Field(default=None, description="the pricing plan of the private offer", alias="privateOfferPlan")
    product: Optional[StrictStr] = Field(default=None, description="in format of \"product/product-durable-id\"")
    product_name: Optional[StrictStr] = Field(default=None, alias="productName")
    suger_offer_id: Optional[StrictStr] = Field(default=None, alias="sugerOfferId")
    __properties: ClassVar[List[str]] = ["basePlan", "discountPercentage", "discountType", "markupPercentage", "newPlanDetails", "originalPlan", "plan", "planId", "planName", "planType", "priceDetails", "privateOfferPlan", "product", "productName", "sugerOfferId"]

    @field_validator('plan_type')
    def plan_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FLAT_RATE', 'PER_USER']):
            raise ValueError("must be one of enum values ('FLAT_RATE', 'PER_USER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplacePrivateOfferPricing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of new_plan_details
        if self.new_plan_details:
            _dict['newPlanDetails'] = self.new_plan_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of original_plan
        if self.original_plan:
            _dict['originalPlan'] = self.original_plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of private_offer_plan
        if self.private_offer_plan:
            _dict['privateOfferPlan'] = self.private_offer_plan.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplacePrivateOfferPricing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "basePlan": obj.get("basePlan"),
            "discountPercentage": obj.get("discountPercentage"),
            "discountType": obj.get("discountType"),
            "markupPercentage": obj.get("markupPercentage"),
            "newPlanDetails": AzureMarketplacePrivateOfferPricingNewPlanDetails.from_dict(obj["newPlanDetails"]) if obj.get("newPlanDetails") is not None else None,
            "originalPlan": AzureMarketplacePriceAndAvailabilityPrivateOfferPlan.from_dict(obj["originalPlan"]) if obj.get("originalPlan") is not None else None,
            "plan": obj.get("plan"),
            "planId": obj.get("planId"),
            "planName": obj.get("planName"),
            "planType": obj.get("planType"),
            "priceDetails": obj.get("priceDetails"),
            "privateOfferPlan": AzureMarketplacePriceAndAvailabilityPrivateOfferPlan.from_dict(obj["privateOfferPlan"]) if obj.get("privateOfferPlan") is not None else None,
            "product": obj.get("product"),
            "productName": obj.get("productName"),
            "sugerOfferId": obj.get("sugerOfferId")
        })
        return _obj


