# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_commercial_marketplace_setup import AzureCommercialMarketplaceSetup
from suger_sdk_python.models.azure_marketplace_customer_leads import AzureMarketplaceCustomerLeads
from suger_sdk_python.models.azure_marketplace_listing import AzureMarketplaceListing
from suger_sdk_python.models.azure_marketplace_listing_asset import AzureMarketplaceListingAsset
from suger_sdk_python.models.azure_marketplace_plan_resource import AzureMarketplacePlanResource
from suger_sdk_python.models.azure_marketplace_price_and_availability_custom_meter import AzureMarketplacePriceAndAvailabilityCustomMeter
from suger_sdk_python.models.azure_marketplace_price_and_availability_offer import AzureMarketplacePriceAndAvailabilityOffer
from suger_sdk_python.models.azure_marketplace_product import AzureMarketplaceProduct
from suger_sdk_python.models.azure_marketplace_property import AzureMarketplaceProperty
from suger_sdk_python.models.azure_marketplace_reseller import AzureMarketplaceReseller
from suger_sdk_python.models.azure_marketplace_saas_technical_configuration import AzureMarketplaceSaasTechnicalConfiguration
from suger_sdk_python.models.azure_marketplace_submission import AzureMarketplaceSubmission
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplaceProductResource(BaseModel):
    """
    AzureMarketplaceProductResource
    """ # noqa: E501
    customer_leads: Optional[AzureMarketplaceCustomerLeads] = Field(default=None, alias="customerLeads")
    listing: Optional[AzureMarketplaceListing] = None
    listing_assets: Optional[List[AzureMarketplaceListingAsset]] = Field(default=None, alias="listingAssets")
    plans: Optional[List[AzureMarketplacePlanResource]] = None
    price_and_availability_custom_meter: Optional[AzureMarketplacePriceAndAvailabilityCustomMeter] = Field(default=None, alias="priceAndAvailabilityCustomMeter")
    price_and_availability_offer: Optional[AzureMarketplacePriceAndAvailabilityOffer] = Field(default=None, alias="priceAndAvailabilityOffer")
    product: Optional[AzureMarketplaceProduct] = None
    var_property: Optional[AzureMarketplaceProperty] = Field(default=None, alias="property")
    reseller: Optional[AzureMarketplaceReseller] = None
    setup: Optional[AzureCommercialMarketplaceSetup] = None
    submission: Optional[AzureMarketplaceSubmission] = None
    technical_configuration: Optional[AzureMarketplaceSaasTechnicalConfiguration] = Field(default=None, alias="technicalConfiguration")
    __properties: ClassVar[List[str]] = ["customerLeads", "listing", "listingAssets", "plans", "priceAndAvailabilityCustomMeter", "priceAndAvailabilityOffer", "product", "property", "reseller", "setup", "submission", "technicalConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplaceProductResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of customer_leads
        if self.customer_leads:
            _dict['customerLeads'] = self.customer_leads.to_dict()
        # override the default output from pydantic by calling `to_dict()` of listing
        if self.listing:
            _dict['listing'] = self.listing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in listing_assets (list)
        _items = []
        if self.listing_assets:
            for _item_listing_assets in self.listing_assets:
                if _item_listing_assets:
                    _items.append(_item_listing_assets.to_dict())
            _dict['listingAssets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in plans (list)
        _items = []
        if self.plans:
            for _item_plans in self.plans:
                if _item_plans:
                    _items.append(_item_plans.to_dict())
            _dict['plans'] = _items
        # override the default output from pydantic by calling `to_dict()` of price_and_availability_custom_meter
        if self.price_and_availability_custom_meter:
            _dict['priceAndAvailabilityCustomMeter'] = self.price_and_availability_custom_meter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_and_availability_offer
        if self.price_and_availability_offer:
            _dict['priceAndAvailabilityOffer'] = self.price_and_availability_offer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product
        if self.product:
            _dict['product'] = self.product.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_property
        if self.var_property:
            _dict['property'] = self.var_property.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reseller
        if self.reseller:
            _dict['reseller'] = self.reseller.to_dict()
        # override the default output from pydantic by calling `to_dict()` of setup
        if self.setup:
            _dict['setup'] = self.setup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of submission
        if self.submission:
            _dict['submission'] = self.submission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of technical_configuration
        if self.technical_configuration:
            _dict['technicalConfiguration'] = self.technical_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplaceProductResource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customerLeads": AzureMarketplaceCustomerLeads.from_dict(obj["customerLeads"]) if obj.get("customerLeads") is not None else None,
            "listing": AzureMarketplaceListing.from_dict(obj["listing"]) if obj.get("listing") is not None else None,
            "listingAssets": [AzureMarketplaceListingAsset.from_dict(_item) for _item in obj["listingAssets"]] if obj.get("listingAssets") is not None else None,
            "plans": [AzureMarketplacePlanResource.from_dict(_item) for _item in obj["plans"]] if obj.get("plans") is not None else None,
            "priceAndAvailabilityCustomMeter": AzureMarketplacePriceAndAvailabilityCustomMeter.from_dict(obj["priceAndAvailabilityCustomMeter"]) if obj.get("priceAndAvailabilityCustomMeter") is not None else None,
            "priceAndAvailabilityOffer": AzureMarketplacePriceAndAvailabilityOffer.from_dict(obj["priceAndAvailabilityOffer"]) if obj.get("priceAndAvailabilityOffer") is not None else None,
            "product": AzureMarketplaceProduct.from_dict(obj["product"]) if obj.get("product") is not None else None,
            "property": AzureMarketplaceProperty.from_dict(obj["property"]) if obj.get("property") is not None else None,
            "reseller": AzureMarketplaceReseller.from_dict(obj["reseller"]) if obj.get("reseller") is not None else None,
            "setup": AzureCommercialMarketplaceSetup.from_dict(obj["setup"]) if obj.get("setup") is not None else None,
            "submission": AzureMarketplaceSubmission.from_dict(obj["submission"]) if obj.get("submission") is not None else None,
            "technicalConfiguration": AzureMarketplaceSaasTechnicalConfiguration.from_dict(obj["technicalConfiguration"]) if obj.get("technicalConfiguration") is not None else None
        })
        return _obj


