# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_marketplace_custom_amendment import AzureMarketplaceCustomAmendment
from suger_sdk_python.models.azure_marketplace_resource_lifecycle_state import AzureMarketplaceResourceLifecycleState
from suger_sdk_python.models.azure_marketplace_validation import AzureMarketplaceValidation
from typing import Optional, Set
from typing_extensions import Self

class AzureMarketplaceProperty(BaseModel):
    """
    AzureMarketplaceProperty
    """ # noqa: E501
    var_schema: Optional[StrictStr] = Field(default=None, alias="$schema")
    app_version: Optional[StrictStr] = Field(default=None, alias="appVersion")
    categories: Optional[Dict[str, List[StrictStr]]] = None
    cloud_industries: Optional[Dict[str, List[StrictStr]]] = Field(default=None, alias="cloudIndustries")
    custom_amendments: Optional[List[AzureMarketplaceCustomAmendment]] = Field(default=None, alias="customAmendments")
    id: Optional[StrictStr] = None
    industries: Optional[Dict[str, List[StrictStr]]] = None
    kind: Optional[StrictStr] = None
    lifecycle_state: Optional[AzureMarketplaceResourceLifecycleState] = Field(default=None, alias="lifecycleState")
    product: Optional[StrictStr] = None
    resource_name: Optional[StrictStr] = Field(default=None, alias="resourceName")
    standard_contract_amendment: Optional[StrictStr] = Field(default=None, alias="standardContractAmendment")
    terms_conditions: Optional[StrictStr] = Field(default=None, alias="termsConditions")
    terms_of_use: Optional[StrictStr] = Field(default=None, alias="termsOfUse")
    terms_of_use_url: Optional[StrictStr] = Field(default=None, alias="termsOfUseUrl")
    validations: Optional[List[AzureMarketplaceValidation]] = None
    __properties: ClassVar[List[str]] = ["$schema", "appVersion", "categories", "cloudIndustries", "customAmendments", "id", "industries", "kind", "lifecycleState", "product", "resourceName", "standardContractAmendment", "termsConditions", "termsOfUse", "termsOfUseUrl", "validations"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['azureSaaS', 'azureVM']):
            raise ValueError("must be one of enum values ('azureSaaS', 'azureVM')")
        return value

    @field_validator('terms_conditions')
    def terms_conditions_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['custom', 'standardMicrosoft']):
            raise ValueError("must be one of enum values ('custom', 'standardMicrosoft')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureMarketplaceProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_amendments (list)
        _items = []
        if self.custom_amendments:
            for _item_custom_amendments in self.custom_amendments:
                if _item_custom_amendments:
                    _items.append(_item_custom_amendments.to_dict())
            _dict['customAmendments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in validations (list)
        _items = []
        if self.validations:
            for _item_validations in self.validations:
                if _item_validations:
                    _items.append(_item_validations.to_dict())
            _dict['validations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureMarketplaceProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "$schema": obj.get("$schema"),
            "appVersion": obj.get("appVersion"),
            "categories": obj.get("categories"),
            "cloudIndustries": obj.get("cloudIndustries"),
            "customAmendments": [AzureMarketplaceCustomAmendment.from_dict(_item) for _item in obj["customAmendments"]] if obj.get("customAmendments") is not None else None,
            "id": obj.get("id"),
            "industries": obj.get("industries"),
            "kind": obj.get("kind"),
            "lifecycleState": obj.get("lifecycleState"),
            "product": obj.get("product"),
            "resourceName": obj.get("resourceName"),
            "standardContractAmendment": obj.get("standardContractAmendment"),
            "termsConditions": obj.get("termsConditions"),
            "termsOfUse": obj.get("termsOfUse"),
            "termsOfUseUrl": obj.get("termsOfUseUrl"),
            "validations": [AzureMarketplaceValidation.from_dict(_item) for _item in obj["validations"]] if obj.get("validations") is not None else None
        })
        return _obj


