# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_audience import AzureAudience
from suger_sdk_python.models.azure_market import AzureMarket
from suger_sdk_python.models.azure_market_state import AzureMarketState
from suger_sdk_python.models.azure_product_variant_custom_meter import AzureProductVariantCustomMeter
from suger_sdk_python.models.azure_product_variant_price_schedule import AzureProductVariantPriceSchedule
from suger_sdk_python.models.azure_product_variant_trial import AzureProductVariantTrial
from suger_sdk_python.models.azure_type_value import AzureTypeValue
from typing import Optional, Set
from typing_extensions import Self

class AzureProductFeatureAvailability(BaseModel):
    """
    AzureProductFeatureAvailability
    """ # noqa: E501
    custom_meters: Optional[List[AzureProductVariantCustomMeter]] = Field(default=None, alias="customMeters")
    id: Optional[StrictStr] = None
    is_hidden: Optional[StrictBool] = Field(default=None, alias="isHidden")
    market_states: Optional[List[AzureMarketState]] = Field(default=None, alias="marketStates")
    markets: Optional[List[AzureMarket]] = None
    price_schedules: Optional[List[AzureProductVariantPriceSchedule]] = Field(default=None, alias="priceSchedules")
    properties: Optional[List[AzureTypeValue]] = None
    resource_type: Optional[StrictStr] = Field(default=None, description="ResourceType = FeatureAvailability", alias="resourceType")
    subscription_audiences: Optional[List[AzureAudience]] = Field(default=None, alias="subscriptionAudiences")
    tenant_audiences: Optional[List[AzureAudience]] = Field(default=None, alias="tenantAudiences")
    trial: Optional[AzureProductVariantTrial] = None
    visibility: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["customMeters", "id", "isHidden", "marketStates", "markets", "priceSchedules", "properties", "resourceType", "subscriptionAudiences", "tenantAudiences", "trial", "visibility"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Public', 'Private']):
            raise ValueError("must be one of enum values ('Public', 'Private')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductFeatureAvailability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_meters (list)
        _items = []
        if self.custom_meters:
            for _item_custom_meters in self.custom_meters:
                if _item_custom_meters:
                    _items.append(_item_custom_meters.to_dict())
            _dict['customMeters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in market_states (list)
        _items = []
        if self.market_states:
            for _item_market_states in self.market_states:
                if _item_market_states:
                    _items.append(_item_market_states.to_dict())
            _dict['marketStates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in markets (list)
        _items = []
        if self.markets:
            for _item_markets in self.markets:
                if _item_markets:
                    _items.append(_item_markets.to_dict())
            _dict['markets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_schedules (list)
        _items = []
        if self.price_schedules:
            for _item_price_schedules in self.price_schedules:
                if _item_price_schedules:
                    _items.append(_item_price_schedules.to_dict())
            _dict['priceSchedules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['properties'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subscription_audiences (list)
        _items = []
        if self.subscription_audiences:
            for _item_subscription_audiences in self.subscription_audiences:
                if _item_subscription_audiences:
                    _items.append(_item_subscription_audiences.to_dict())
            _dict['subscriptionAudiences'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tenant_audiences (list)
        _items = []
        if self.tenant_audiences:
            for _item_tenant_audiences in self.tenant_audiences:
                if _item_tenant_audiences:
                    _items.append(_item_tenant_audiences.to_dict())
            _dict['tenantAudiences'] = _items
        # override the default output from pydantic by calling `to_dict()` of trial
        if self.trial:
            _dict['trial'] = self.trial.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductFeatureAvailability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customMeters": [AzureProductVariantCustomMeter.from_dict(_item) for _item in obj["customMeters"]] if obj.get("customMeters") is not None else None,
            "id": obj.get("id"),
            "isHidden": obj.get("isHidden"),
            "marketStates": [AzureMarketState.from_dict(_item) for _item in obj["marketStates"]] if obj.get("marketStates") is not None else None,
            "markets": [AzureMarket.from_dict(_item) for _item in obj["markets"]] if obj.get("markets") is not None else None,
            "priceSchedules": [AzureProductVariantPriceSchedule.from_dict(_item) for _item in obj["priceSchedules"]] if obj.get("priceSchedules") is not None else None,
            "properties": [AzureTypeValue.from_dict(_item) for _item in obj["properties"]] if obj.get("properties") is not None else None,
            "resourceType": obj.get("resourceType"),
            "subscriptionAudiences": [AzureAudience.from_dict(_item) for _item in obj["subscriptionAudiences"]] if obj.get("subscriptionAudiences") is not None else None,
            "tenantAudiences": [AzureAudience.from_dict(_item) for _item in obj["tenantAudiences"]] if obj.get("tenantAudiences") is not None else None,
            "trial": AzureProductVariantTrial.from_dict(obj["trial"]) if obj.get("trial") is not None else None,
            "visibility": obj.get("visibility")
        })
        return _obj


