# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_listing_contact import AzureListingContact
from suger_sdk_python.models.azure_listing_uri import AzureListingUri
from suger_sdk_python.models.azure_product_listing_asset import AzureProductListingAsset
from typing import Optional, Set
from typing_extensions import Self

class AzureProductListing(BaseModel):
    """
    AzureProductListing
    """ # noqa: E501
    access_information: Optional[StrictStr] = Field(default=None, alias="accessInformation")
    assets: Optional[List[AzureProductListingAsset]] = Field(default=None, description="Not original fields. They are populated by other API calls")
    compatible_products: Optional[List[StrictStr]] = Field(default=None, alias="compatibleProducts")
    description: Optional[StrictStr] = None
    getting_started_instructions: Optional[StrictStr] = Field(default=None, alias="gettingStartedInstructions")
    id: Optional[StrictStr] = None
    keywords: Optional[List[StrictStr]] = None
    language_code: Optional[StrictStr] = Field(default=None, alias="languageCode")
    listing_contacts: Optional[List[AzureListingContact]] = Field(default=None, alias="listingContacts")
    listing_uris: Optional[List[AzureListingUri]] = Field(default=None, alias="listingUris")
    product_display_name: Optional[StrictStr] = Field(default=None, alias="productDisplayName")
    publisher_name: Optional[StrictStr] = Field(default=None, alias="publisherName")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    short_description: Optional[StrictStr] = Field(default=None, alias="shortDescription")
    summary: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["accessInformation", "assets", "compatibleProducts", "description", "gettingStartedInstructions", "id", "keywords", "languageCode", "listingContacts", "listingUris", "productDisplayName", "publisherName", "resourceType", "shortDescription", "summary", "title"]

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AzureListing']):
            raise ValueError("must be one of enum values ('AzureListing')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductListing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assets (list)
        _items = []
        if self.assets:
            for _item_assets in self.assets:
                if _item_assets:
                    _items.append(_item_assets.to_dict())
            _dict['assets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in listing_contacts (list)
        _items = []
        if self.listing_contacts:
            for _item_listing_contacts in self.listing_contacts:
                if _item_listing_contacts:
                    _items.append(_item_listing_contacts.to_dict())
            _dict['listingContacts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in listing_uris (list)
        _items = []
        if self.listing_uris:
            for _item_listing_uris in self.listing_uris:
                if _item_listing_uris:
                    _items.append(_item_listing_uris.to_dict())
            _dict['listingUris'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductListing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accessInformation": obj.get("accessInformation"),
            "assets": [AzureProductListingAsset.from_dict(_item) for _item in obj["assets"]] if obj.get("assets") is not None else None,
            "compatibleProducts": obj.get("compatibleProducts"),
            "description": obj.get("description"),
            "gettingStartedInstructions": obj.get("gettingStartedInstructions"),
            "id": obj.get("id"),
            "keywords": obj.get("keywords"),
            "languageCode": obj.get("languageCode"),
            "listingContacts": [AzureListingContact.from_dict(_item) for _item in obj["listingContacts"]] if obj.get("listingContacts") is not None else None,
            "listingUris": [AzureListingUri.from_dict(_item) for _item in obj["listingUris"]] if obj.get("listingUris") is not None else None,
            "productDisplayName": obj.get("productDisplayName"),
            "publisherName": obj.get("publisherName"),
            "resourceType": obj.get("resourceType"),
            "shortDescription": obj.get("shortDescription"),
            "summary": obj.get("summary"),
            "title": obj.get("title")
        })
        return _obj


