# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AzureProductListingAsset(BaseModel):
    """
    AzureProductListingAsset
    """ # noqa: E501
    description: Optional[StrictStr] = None
    file_name: Optional[StrictStr] = Field(default=None, alias="fileName")
    file_sas_uri: Optional[StrictStr] = Field(default=None, alias="fileSasUri")
    friendly_name: Optional[StrictStr] = Field(default=None, alias="friendlyName")
    id: Optional[StrictStr] = None
    order: Optional[StrictInt] = None
    publisher_defined_sas_uri: Optional[StrictStr] = Field(default=None, alias="publisherDefinedSasUri")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    state: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["description", "fileName", "fileSasUri", "friendlyName", "id", "order", "publisherDefinedSasUri", "resourceType", "state", "type"]

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ListingAsset', 'ListingImage', 'ListingVideo']):
            raise ValueError("must be one of enum values ('ListingAsset', 'ListingImage', 'ListingVideo')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PendingUpload', 'Uploaded', 'InProcessing', 'Processed', 'ProcessFailed']):
            raise ValueError("must be one of enum values ('PendingUpload', 'Uploaded', 'InProcessing', 'Processed', 'ProcessFailed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductListingAsset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductListingAsset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "fileName": obj.get("fileName"),
            "fileSasUri": obj.get("fileSasUri"),
            "friendlyName": obj.get("friendlyName"),
            "id": obj.get("id"),
            "order": obj.get("order"),
            "publisherDefinedSasUri": obj.get("publisherDefinedSasUri"),
            "resourceType": obj.get("resourceType"),
            "state": obj.get("state"),
            "type": obj.get("type")
        })
        return _obj


