# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AzureProductProperty(BaseModel):
    """
    AzureProductProperty
    """ # noqa: E501
    additional_categories: Optional[List[StrictStr]] = Field(default=None, alias="additionalCategories")
    app_version: Optional[StrictStr] = Field(default=None, alias="appVersion")
    applicable_products: Optional[List[StrictStr]] = Field(default=None, alias="applicableProducts")
    categories: Optional[List[StrictStr]] = None
    custom_amendments: Optional[List[StrictStr]] = Field(default=None, alias="customAmendments")
    extended_properties: Optional[List[StrictStr]] = Field(default=None, alias="extendedProperties")
    global_amendment_terms: Optional[StrictStr] = Field(default=None, alias="globalAmendmentTerms")
    hide_keys: Optional[List[StrictStr]] = Field(default=None, alias="hideKeys")
    id: Optional[StrictStr] = None
    industries: Optional[List[StrictStr]] = None
    leveled_categories: Optional[Dict[str, Any]] = Field(default=None, alias="leveledCategories")
    leveled_industries: Optional[Dict[str, Any]] = Field(default=None, alias="leveledIndustries")
    marketing_only_change: Optional[StrictBool] = Field(default=None, alias="marketingOnlyChange")
    product_tags: Optional[List[StrictStr]] = Field(default=None, alias="productTags")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    submission_version: Optional[StrictStr] = Field(default=None, alias="submissionVersion")
    terms_of_use: Optional[StrictStr] = Field(default=None, alias="termsOfUse")
    use_enterprise_contract: Optional[StrictBool] = Field(default=None, alias="useEnterpriseContract")
    __properties: ClassVar[List[str]] = ["additionalCategories", "appVersion", "applicableProducts", "categories", "customAmendments", "extendedProperties", "globalAmendmentTerms", "hideKeys", "id", "industries", "leveledCategories", "leveledIndustries", "marketingOnlyChange", "productTags", "resourceType", "submissionVersion", "termsOfUse", "useEnterpriseContract"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "additionalCategories": obj.get("additionalCategories"),
            "appVersion": obj.get("appVersion"),
            "applicableProducts": obj.get("applicableProducts"),
            "categories": obj.get("categories"),
            "customAmendments": obj.get("customAmendments"),
            "extendedProperties": obj.get("extendedProperties"),
            "globalAmendmentTerms": obj.get("globalAmendmentTerms"),
            "hideKeys": obj.get("hideKeys"),
            "id": obj.get("id"),
            "industries": obj.get("industries"),
            "leveledCategories": obj.get("leveledCategories"),
            "leveledIndustries": obj.get("leveledIndustries"),
            "marketingOnlyChange": obj.get("marketingOnlyChange"),
            "productTags": obj.get("productTags"),
            "resourceType": obj.get("resourceType"),
            "submissionVersion": obj.get("submissionVersion"),
            "termsOfUse": obj.get("termsOfUse"),
            "useEnterpriseContract": obj.get("useEnterpriseContract")
        })
        return _obj


