# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_type_value import AzureTypeValue
from typing import Optional, Set
from typing_extensions import Self

class AzureProductSetup(BaseModel):
    """
    AzureProductSetup
    """ # noqa: E501
    call_to_action: Optional[StrictStr] = Field(default=None, alias="callToAction")
    channel_states: Optional[List[AzureTypeValue]] = Field(default=None, alias="channelStates")
    enable_test_drive: Optional[StrictBool] = Field(default=None, alias="enableTestDrive")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    selling_option: Optional[StrictStr] = Field(default=None, alias="sellingOption")
    test_drive_type: Optional[StrictStr] = Field(default=None, alias="testDriveType")
    trial_uri: Optional[StrictStr] = Field(default=None, alias="trialUri")
    __properties: ClassVar[List[str]] = ["callToAction", "channelStates", "enableTestDrive", "resourceType", "sellingOption", "testDriveType", "trialUri"]

    @field_validator('call_to_action')
    def call_to_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['free', 'free-trial', 'contact-me']):
            raise ValueError("must be one of enum values ('free', 'free-trial', 'contact-me')")
        return value

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AzureProductSetup']):
            raise ValueError("must be one of enum values ('AzureProductSetup')")
        return value

    @field_validator('selling_option')
    def selling_option_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ListingOnly', 'ListAndSell']):
            raise ValueError("must be one of enum values ('ListingOnly', 'ListAndSell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductSetup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in channel_states (list)
        _items = []
        if self.channel_states:
            for _item_channel_states in self.channel_states:
                if _item_channel_states:
                    _items.append(_item_channel_states.to_dict())
            _dict['channelStates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductSetup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callToAction": obj.get("callToAction"),
            "channelStates": [AzureTypeValue.from_dict(_item) for _item in obj["channelStates"]] if obj.get("channelStates") is not None else None,
            "enableTestDrive": obj.get("enableTestDrive"),
            "resourceType": obj.get("resourceType"),
            "sellingOption": obj.get("sellingOption"),
            "testDriveType": obj.get("testDriveType"),
            "trialUri": obj.get("trialUri")
        })
        return _obj


