# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_pending_update_info import AzurePendingUpdateInfo
from suger_sdk_python.models.azure_type_value import AzureTypeValue
from suger_sdk_python.models.azure_variant_resource import AzureVariantResource
from typing import Optional, Set
from typing_extensions import Self

class AzureProductSubmission(BaseModel):
    """
    AzureProductSubmission
    """ # noqa: E501
    are_resources_ready: Optional[StrictBool] = Field(default=None, alias="areResourcesReady")
    friendly_name: Optional[StrictStr] = Field(default=None, alias="friendlyName")
    id: Optional[StrictStr] = None
    pending_update_info: Optional[AzurePendingUpdateInfo] = Field(default=None, alias="pendingUpdateInfo")
    published_time_in_utc: Optional[datetime] = Field(default=None, alias="publishedTimeInUtc")
    release_number: Optional[StrictInt] = Field(default=None, alias="releaseNumber")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    resources: Optional[List[AzureTypeValue]] = None
    state: Optional[StrictStr] = None
    sub_state: Optional[StrictStr] = Field(default=None, alias="subState")
    targets: Optional[List[AzureTypeValue]] = None
    variant_resources: Optional[List[AzureVariantResource]] = Field(default=None, alias="variantResources")
    __properties: ClassVar[List[str]] = ["areResourcesReady", "friendlyName", "id", "pendingUpdateInfo", "publishedTimeInUtc", "releaseNumber", "resourceType", "resources", "state", "subState", "targets", "variantResources"]

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Submission']):
            raise ValueError("must be one of enum values ('Submission')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Inprogress', 'Published']):
            raise ValueError("must be one of enum values ('Inprogress', 'Published')")
        return value

    @field_validator('sub_state')
    def sub_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['InDraft', 'Submitted', 'Failed', 'FailedInCertification', 'ReadyToPublish', 'Publishing', 'Published', 'InStore']):
            raise ValueError("must be one of enum values ('InDraft', 'Submitted', 'Failed', 'FailedInCertification', 'ReadyToPublish', 'Publishing', 'Published', 'InStore')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductSubmission from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pending_update_info
        if self.pending_update_info:
            _dict['pendingUpdateInfo'] = self.pending_update_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict['resources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in targets (list)
        _items = []
        if self.targets:
            for _item_targets in self.targets:
                if _item_targets:
                    _items.append(_item_targets.to_dict())
            _dict['targets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in variant_resources (list)
        _items = []
        if self.variant_resources:
            for _item_variant_resources in self.variant_resources:
                if _item_variant_resources:
                    _items.append(_item_variant_resources.to_dict())
            _dict['variantResources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductSubmission from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "areResourcesReady": obj.get("areResourcesReady"),
            "friendlyName": obj.get("friendlyName"),
            "id": obj.get("id"),
            "pendingUpdateInfo": AzurePendingUpdateInfo.from_dict(obj["pendingUpdateInfo"]) if obj.get("pendingUpdateInfo") is not None else None,
            "publishedTimeInUtc": obj.get("publishedTimeInUtc"),
            "releaseNumber": obj.get("releaseNumber"),
            "resourceType": obj.get("resourceType"),
            "resources": [AzureTypeValue.from_dict(_item) for _item in obj["resources"]] if obj.get("resources") is not None else None,
            "state": obj.get("state"),
            "subState": obj.get("subState"),
            "targets": [AzureTypeValue.from_dict(_item) for _item in obj["targets"]] if obj.get("targets") is not None else None,
            "variantResources": [AzureVariantResource.from_dict(_item) for _item in obj["variantResources"]] if obj.get("variantResources") is not None else None
        })
        return _obj


