# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.azure_government_certification import AzureGovernmentCertification
from suger_sdk_python.models.azure_product_feature_availability import AzureProductFeatureAvailability
from suger_sdk_python.models.azure_type_value import AzureTypeValue
from typing import Optional, Set
from typing_extensions import Self

class AzureProductVariant(BaseModel):
    """
    AzureProductVariant
    """ # noqa: E501
    azure_government_certifications: Optional[List[AzureGovernmentCertification]] = Field(default=None, alias="azureGovernmentCertifications")
    cloud_availabilities: Optional[List[StrictStr]] = Field(default=None, alias="cloudAvailabilities")
    conversion_paths: Optional[StrictStr] = Field(default=None, alias="conversionPaths")
    extended_properties: Optional[List[AzureTypeValue]] = Field(default=None, alias="extendedProperties")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalID")
    feature_availabilities: Optional[List[AzureProductFeatureAvailability]] = Field(default=None, description="Not original fields. They are populated by other API calls", alias="featureAvailabilities")
    friendly_name: Optional[StrictStr] = Field(default=None, alias="friendlyName")
    id: Optional[StrictStr] = None
    lead_gen_id: Optional[StrictStr] = Field(default=None, alias="leadGenID")
    reference_variant_id: Optional[StrictStr] = Field(default=None, alias="referenceVariantID")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    state: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["azureGovernmentCertifications", "cloudAvailabilities", "conversionPaths", "extendedProperties", "externalID", "featureAvailabilities", "friendlyName", "id", "leadGenID", "referenceVariantID", "resourceType", "state"]

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AzureSkuVariant', 'AzureTestDriveVariant']):
            raise ValueError("must be one of enum values ('AzureSkuVariant', 'AzureTestDriveVariant')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['InActive', 'Active']):
            raise ValueError("must be one of enum values ('InActive', 'Active')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzureProductVariant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in azure_government_certifications (list)
        _items = []
        if self.azure_government_certifications:
            for _item_azure_government_certifications in self.azure_government_certifications:
                if _item_azure_government_certifications:
                    _items.append(_item_azure_government_certifications.to_dict())
            _dict['azureGovernmentCertifications'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in extended_properties (list)
        _items = []
        if self.extended_properties:
            for _item_extended_properties in self.extended_properties:
                if _item_extended_properties:
                    _items.append(_item_extended_properties.to_dict())
            _dict['extendedProperties'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in feature_availabilities (list)
        _items = []
        if self.feature_availabilities:
            for _item_feature_availabilities in self.feature_availabilities:
                if _item_feature_availabilities:
                    _items.append(_item_feature_availabilities.to_dict())
            _dict['featureAvailabilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzureProductVariant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "azureGovernmentCertifications": [AzureGovernmentCertification.from_dict(_item) for _item in obj["azureGovernmentCertifications"]] if obj.get("azureGovernmentCertifications") is not None else None,
            "cloudAvailabilities": obj.get("cloudAvailabilities"),
            "conversionPaths": obj.get("conversionPaths"),
            "extendedProperties": [AzureTypeValue.from_dict(_item) for _item in obj["extendedProperties"]] if obj.get("extendedProperties") is not None else None,
            "externalID": obj.get("externalID"),
            "featureAvailabilities": [AzureProductFeatureAvailability.from_dict(_item) for _item in obj["featureAvailabilities"]] if obj.get("featureAvailabilities") is not None else None,
            "friendlyName": obj.get("friendlyName"),
            "id": obj.get("id"),
            "leadGenID": obj.get("leadGenID"),
            "referenceVariantID": obj.get("referenceVariantID"),
            "resourceType": obj.get("resourceType"),
            "state": obj.get("state")
        })
        return _obj


