# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.billing_discount import BillingDiscount
from suger_sdk_python.models.billing_minimum_commit_scope import BillingMinimumCommitScope
from suger_sdk_python.models.price_model_basic import PriceModelBasic
from suger_sdk_python.models.price_model_bulk import PriceModelBulk
from suger_sdk_python.models.price_model_category import PriceModelCategory
from suger_sdk_python.models.price_model_matrix import PriceModelMatrix
from suger_sdk_python.models.price_model_percentage import PriceModelPercentage
from suger_sdk_python.models.price_model_tiered import PriceModelTiered
from suger_sdk_python.models.price_model_tiered_percentage import PriceModelTieredPercentage
from suger_sdk_python.models.price_model_volume import PriceModelVolume
from suger_sdk_python.models.time_unit import TimeUnit
from typing import Optional, Set
from typing_extensions import Self

class BillableDimension(BaseModel):
    """
    BillableDimension
    """ # noqa: E501
    billable_metric_id: Optional[StrictStr] = Field(default=None, description="The ID for the billable metric.", alias="billableMetricId")
    category: Optional[PriceModelCategory] = Field(default=None, description="The category of the pricing model. This is used to determine which pricing model to use.")
    description: Optional[StrictStr] = Field(default=None, description="Description of the dimension. This is used in the UI to display the dimension.")
    discount: Optional[BillingDiscount] = Field(default=None, description="Discount for the dimension.")
    length: Optional[StrictInt] = Field(default=None, description="The term length for the commit amount. Applicable to Direct only.")
    minimum_commit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The minimum commit amount. Applicable to Direct only. Ignored if the value is 0 or less.", alias="minimumCommit")
    minimum_commit_prorata: Optional[StrictBool] = Field(default=None, description="If the minimum commit is appled with pro-rata. Applicable to Direct only. If true, the minimum commit amount will be prorated based on the usage period (starting time and ending time).", alias="minimumCommitProrata")
    minimum_commit_scope: Optional[BillingMinimumCommitScope] = Field(default=None, description="The minimum commit scope. The default value is \"DIMENSION\" if not set.", alias="minimumCommitScope")
    name: Optional[StrictStr] = Field(default=None, description="Display name of the dimension. This is used in the UI to display the dimension.")
    price_model_basic: Optional[PriceModelBasic] = Field(default=None, description="The configuration for the Basic pricing model. Applicable to Direct only.", alias="priceModelBasic")
    price_model_bulk: Optional[PriceModelBulk] = Field(default=None, description="The configuration for the Package pricing model. Applicable to Direct only.", alias="priceModelBulk")
    price_model_matrix: Optional[PriceModelMatrix] = Field(default=None, description="The configuration for the Matrix pricing model. Applicable to Direct only.", alias="priceModelMatrix")
    price_model_percentage: Optional[PriceModelPercentage] = Field(default=None, description="The configuration for the Percentage pricing model. Applicable to Direct only.", alias="priceModelPercentage")
    price_model_tiered: Optional[PriceModelTiered] = Field(default=None, description="The configuration for the Tiered pricing model. Applicable to Direct only.", alias="priceModelTiered")
    price_model_tiered_percentage: Optional[PriceModelTieredPercentage] = Field(default=None, description="The configuration for the Tiered Percentage pricing model. Applicable to Direct only.", alias="priceModelTieredPercentage")
    price_model_volume: Optional[PriceModelVolume] = Field(default=None, description="The configuration for the Bulk pricing model. Applicable to Direct only.", alias="priceModelVolume")
    time_unit: Optional[TimeUnit] = Field(default=None, description="The term unit for the commit amount. Applicable to Direct only.", alias="timeUnit")
    __properties: ClassVar[List[str]] = ["billableMetricId", "category", "description", "discount", "length", "minimumCommit", "minimumCommitProrata", "minimumCommitScope", "name", "priceModelBasic", "priceModelBulk", "priceModelMatrix", "priceModelPercentage", "priceModelTiered", "priceModelTieredPercentage", "priceModelVolume", "timeUnit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillableDimension from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_basic
        if self.price_model_basic:
            _dict['priceModelBasic'] = self.price_model_basic.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_bulk
        if self.price_model_bulk:
            _dict['priceModelBulk'] = self.price_model_bulk.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_matrix
        if self.price_model_matrix:
            _dict['priceModelMatrix'] = self.price_model_matrix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_percentage
        if self.price_model_percentage:
            _dict['priceModelPercentage'] = self.price_model_percentage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_tiered
        if self.price_model_tiered:
            _dict['priceModelTiered'] = self.price_model_tiered.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_tiered_percentage
        if self.price_model_tiered_percentage:
            _dict['priceModelTieredPercentage'] = self.price_model_tiered_percentage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_volume
        if self.price_model_volume:
            _dict['priceModelVolume'] = self.price_model_volume.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillableDimension from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "billableMetricId": obj.get("billableMetricId"),
            "category": obj.get("category"),
            "description": obj.get("description"),
            "discount": BillingDiscount.from_dict(obj["discount"]) if obj.get("discount") is not None else None,
            "length": obj.get("length"),
            "minimumCommit": obj.get("minimumCommit"),
            "minimumCommitProrata": obj.get("minimumCommitProrata"),
            "minimumCommitScope": obj.get("minimumCommitScope"),
            "name": obj.get("name"),
            "priceModelBasic": PriceModelBasic.from_dict(obj["priceModelBasic"]) if obj.get("priceModelBasic") is not None else None,
            "priceModelBulk": PriceModelBulk.from_dict(obj["priceModelBulk"]) if obj.get("priceModelBulk") is not None else None,
            "priceModelMatrix": PriceModelMatrix.from_dict(obj["priceModelMatrix"]) if obj.get("priceModelMatrix") is not None else None,
            "priceModelPercentage": PriceModelPercentage.from_dict(obj["priceModelPercentage"]) if obj.get("priceModelPercentage") is not None else None,
            "priceModelTiered": PriceModelTiered.from_dict(obj["priceModelTiered"]) if obj.get("priceModelTiered") is not None else None,
            "priceModelTieredPercentage": PriceModelTieredPercentage.from_dict(obj["priceModelTieredPercentage"]) if obj.get("priceModelTieredPercentage") is not None else None,
            "priceModelVolume": PriceModelVolume.from_dict(obj["priceModelVolume"]) if obj.get("priceModelVolume") is not None else None,
            "timeUnit": obj.get("timeUnit")
        })
        return _obj


