# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from suger_sdk_python.models.billing_addon_info import BillingAddonInfo
from suger_sdk_python.models.billing_addon_status import BillingAddonStatus
from typing import Optional, Set
from typing_extensions import Self

class BillingAddon(BaseModel):
    """
    BillingAddon
    """ # noqa: E501
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    description: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="Description of the addon")
    id: Optional[Annotated[str, Field(strict=True, max_length=36)]] = None
    info: Optional[BillingAddonInfo] = None
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    name: Optional[Annotated[str, Field(min_length=4, strict=True, max_length=50)]] = Field(default=None, description="Name of the addon, e.g. \"Support Plan\"")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    status: Optional[BillingAddonStatus] = None
    __properties: ClassVar[List[str]] = ["creationTime", "description", "id", "info", "lastUpdateTime", "name", "organizationID", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingAddon from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingAddon from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creationTime": obj.get("creationTime"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "info": BillingAddonInfo.from_dict(obj["info"]) if obj.get("info") is not None else None,
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "name": obj.get("name"),
            "organizationID": obj.get("organizationID"),
            "status": obj.get("status")
        })
        return _obj


