# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from suger_sdk_python.models.billing_invoice_info import BillingInvoiceInfo
from suger_sdk_python.models.billing_invoice_status import BillingInvoiceStatus
from suger_sdk_python.models.billing_invoice_type import BillingInvoiceType
from suger_sdk_python.models.billing_payment_status import BillingPaymentStatus
from typing import Optional, Set
from typing_extensions import Self

class BillingInvoice(BaseModel):
    """
    BillingInvoice
    """ # noqa: E501
    buyer_id: Optional[Annotated[str, Field(strict=True, max_length=36)]] = Field(default=None, alias="buyerID")
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    entitlement_id: Optional[Annotated[str, Field(strict=True, max_length=36)]] = Field(default=None, alias="entitlementID")
    id: Optional[Annotated[str, Field(strict=True, max_length=36)]] = None
    info: Optional[BillingInvoiceInfo] = None
    invoice_url: Optional[StrictStr] = Field(default=None, description="The invoice file URL, provided as AWS S3 presigned URL with expiration time. Output only.", alias="invoiceURL")
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    payment_status: Optional[BillingPaymentStatus] = Field(default=None, alias="paymentStatus")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    status: Optional[BillingInvoiceStatus] = None
    type: Optional[BillingInvoiceType] = None
    __properties: ClassVar[List[str]] = ["buyerID", "creationTime", "endDate", "entitlementID", "id", "info", "invoiceURL", "lastUpdateTime", "organizationID", "paymentStatus", "startDate", "status", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingInvoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingInvoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "buyerID": obj.get("buyerID"),
            "creationTime": obj.get("creationTime"),
            "endDate": obj.get("endDate"),
            "entitlementID": obj.get("entitlementID"),
            "id": obj.get("id"),
            "info": BillingInvoiceInfo.from_dict(obj["info"]) if obj.get("info") is not None else None,
            "invoiceURL": obj.get("invoiceURL"),
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "organizationID": obj.get("organizationID"),
            "paymentStatus": obj.get("paymentStatus"),
            "startDate": obj.get("startDate"),
            "status": obj.get("status"),
            "type": obj.get("type")
        })
        return _obj


