# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.billing_payment_status import BillingPaymentStatus
from suger_sdk_python.models.billing_payment_transaction_info import BillingPaymentTransactionInfo
from suger_sdk_python.models.billing_payment_transaction_type import BillingPaymentTransactionType
from suger_sdk_python.models.billing_wallet_type import BillingWalletType
from suger_sdk_python.models.partner import Partner
from typing import Optional, Set
from typing_extensions import Self

class BillingPaymentTransaction(BaseModel):
    """
    BillingPaymentTransaction
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    currency: Optional[StrictStr] = None
    entitlement_id: Optional[StrictStr] = Field(default=None, alias="entitlementID")
    id: Optional[StrictStr] = None
    info: Optional[BillingPaymentTransactionInfo] = None
    invoice_id: Optional[StrictStr] = Field(default=None, alias="invoiceID")
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentID")
    partner: Optional[Partner] = None
    status: Optional[BillingPaymentStatus] = None
    type: Optional[BillingPaymentTransactionType] = None
    wallet_id: Optional[StrictStr] = Field(default=None, alias="walletID")
    wallet_type: Optional[BillingWalletType] = Field(default=None, alias="walletType")
    __properties: ClassVar[List[str]] = ["amount", "buyerID", "creationTime", "currency", "entitlementID", "id", "info", "invoiceID", "lastUpdateTime", "organizationID", "parentID", "partner", "status", "type", "walletID", "walletType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingPaymentTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingPaymentTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "buyerID": obj.get("buyerID"),
            "creationTime": obj.get("creationTime"),
            "currency": obj.get("currency"),
            "entitlementID": obj.get("entitlementID"),
            "id": obj.get("id"),
            "info": BillingPaymentTransactionInfo.from_dict(obj["info"]) if obj.get("info") is not None else None,
            "invoiceID": obj.get("invoiceID"),
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "organizationID": obj.get("organizationID"),
            "parentID": obj.get("parentID"),
            "partner": obj.get("partner"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "walletID": obj.get("walletID"),
            "walletType": obj.get("walletType")
        })
        return _obj


