# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.stripe_balance_transaction import StripeBalanceTransaction
from suger_sdk_python.models.stripe_dispute import StripeDispute
from suger_sdk_python.models.stripe_error import StripeError
from suger_sdk_python.models.stripe_payment_intent import StripePaymentIntent
from suger_sdk_python.models.stripe_refund import StripeRefund
from typing import Optional, Set
from typing_extensions import Self

class BillingPaymentTransactionInfo(BaseModel):
    """
    BillingPaymentTransactionInfo
    """ # noqa: E501
    invoice_date: Optional[datetime] = Field(default=None, description="The invoice issue date.", alias="invoiceDate")
    refund_exists: Optional[StrictBool] = Field(default=None, description="Refund flag marks whether the transaction has any refund records.", alias="refundExists")
    stripe_balance_transaction: Optional[StripeBalanceTransaction] = Field(default=None, description="Balance transaction that describes the impact of this charge on your account balance.", alias="stripeBalanceTransaction")
    stripe_disputes: Optional[List[StripeDispute]] = Field(default=None, description="Stripe dispute result, got by Dispute API, there may be multiple disputes.", alias="stripeDisputes")
    stripe_error: Optional[StripeError] = Field(default=None, description="Error of stripe API call", alias="stripeError")
    stripe_payment_intent: Optional[StripePaymentIntent] = Field(default=None, description="Stripe payment intent result, got by PaymentIntent API", alias="stripePaymentIntent")
    stripe_refund: Optional[StripeRefund] = Field(default=None, description="Stripe refund result, got by Refund API", alias="stripeRefund")
    __properties: ClassVar[List[str]] = ["invoiceDate", "refundExists", "stripeBalanceTransaction", "stripeDisputes", "stripeError", "stripePaymentIntent", "stripeRefund"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingPaymentTransactionInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of stripe_balance_transaction
        if self.stripe_balance_transaction:
            _dict['stripeBalanceTransaction'] = self.stripe_balance_transaction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in stripe_disputes (list)
        _items = []
        if self.stripe_disputes:
            for _item_stripe_disputes in self.stripe_disputes:
                if _item_stripe_disputes:
                    _items.append(_item_stripe_disputes.to_dict())
            _dict['stripeDisputes'] = _items
        # override the default output from pydantic by calling `to_dict()` of stripe_error
        if self.stripe_error:
            _dict['stripeError'] = self.stripe_error.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stripe_payment_intent
        if self.stripe_payment_intent:
            _dict['stripePaymentIntent'] = self.stripe_payment_intent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stripe_refund
        if self.stripe_refund:
            _dict['stripeRefund'] = self.stripe_refund.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingPaymentTransactionInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "invoiceDate": obj.get("invoiceDate"),
            "refundExists": obj.get("refundExists"),
            "stripeBalanceTransaction": StripeBalanceTransaction.from_dict(obj["stripeBalanceTransaction"]) if obj.get("stripeBalanceTransaction") is not None else None,
            "stripeDisputes": [StripeDispute.from_dict(_item) for _item in obj["stripeDisputes"]] if obj.get("stripeDisputes") is not None else None,
            "stripeError": StripeError.from_dict(obj["stripeError"]) if obj.get("stripeError") is not None else None,
            "stripePaymentIntent": StripePaymentIntent.from_dict(obj["stripePaymentIntent"]) if obj.get("stripePaymentIntent") is not None else None,
            "stripeRefund": StripeRefund.from_dict(obj["stripeRefund"]) if obj.get("stripeRefund") is not None else None
        })
        return _obj


