# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.billing_wallet_info import BillingWalletInfo
from suger_sdk_python.models.billing_wallet_status import BillingWalletStatus
from suger_sdk_python.models.billing_wallet_type import BillingWalletType
from suger_sdk_python.models.partner import Partner
from typing import Optional, Set
from typing_extensions import Self

class BillingWallet(BaseModel):
    """
    BillingWallet
    """ # noqa: E501
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    currency: Optional[StrictStr] = None
    expire_time: Optional[datetime] = Field(default=None, description="nullable", alias="expireTime")
    external_id: Optional[StrictStr] = Field(default=None, description="The payment method id in payment provider, such as stripe payment method id.", alias="externalID")
    id: Optional[StrictStr] = None
    info: Optional[BillingWalletInfo] = None
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    name: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    partner: Optional[Partner] = None
    start_time: Optional[datetime] = Field(default=None, alias="startTime")
    status: Optional[BillingWalletStatus] = None
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalAmount")
    type: Optional[BillingWalletType] = None
    used_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="usedAmount")
    __properties: ClassVar[List[str]] = ["buyerID", "creationTime", "currency", "expireTime", "externalID", "id", "info", "lastUpdateTime", "name", "organizationID", "partner", "startTime", "status", "totalAmount", "type", "usedAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BillingWallet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BillingWallet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "buyerID": obj.get("buyerID"),
            "creationTime": obj.get("creationTime"),
            "currency": obj.get("currency"),
            "expireTime": obj.get("expireTime"),
            "externalID": obj.get("externalID"),
            "id": obj.get("id"),
            "info": BillingWalletInfo.from_dict(obj["info"]) if obj.get("info") is not None else None,
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "name": obj.get("name"),
            "organizationID": obj.get("organizationID"),
            "partner": obj.get("partner"),
            "startTime": obj.get("startTime"),
            "status": obj.get("status"),
            "totalAmount": obj.get("totalAmount"),
            "type": obj.get("type"),
            "usedAmount": obj.get("usedAmount")
        })
        return _obj


