# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.client_describe_instance_response_body_modules import ClientDescribeInstanceResponseBodyModules
from suger_sdk_python.models.client_describe_instance_response_body_relational_data import ClientDescribeInstanceResponseBodyRelationalData
from typing import Optional, Set
from typing_extensions import Self

class ClientDescribeInstanceResponseBody(BaseModel):
    """
    ClientDescribeInstanceResponseBody
    """ # noqa: E501
    app_json: Optional[StrictStr] = Field(default=None, alias="AppJson")
    auto_renewal: Optional[StrictStr] = Field(default=None, alias="AutoRenewal")
    began_on: Optional[StrictInt] = Field(default=None, alias="BeganOn")
    component_json: Optional[StrictStr] = Field(default=None, alias="ComponentJson")
    constraints: Optional[StrictStr] = Field(default=None, alias="Constraints")
    created_on: Optional[StrictInt] = Field(default=None, alias="CreatedOn")
    end_on: Optional[StrictInt] = Field(default=None, alias="EndOn")
    extend_json: Optional[StrictStr] = Field(default=None, alias="ExtendJson")
    host_json: Optional[StrictStr] = Field(default=None, alias="HostJson")
    instance_id: Optional[StrictInt] = Field(default=None, alias="InstanceId")
    is_trial: Optional[StrictBool] = Field(default=None, alias="IsTrial")
    modules: Optional[ClientDescribeInstanceResponseBodyModules] = Field(default=None, alias="Modules")
    order_id: Optional[StrictInt] = Field(default=None, alias="OrderId")
    product_code: Optional[StrictStr] = Field(default=None, alias="ProductCode")
    product_name: Optional[StrictStr] = Field(default=None, alias="ProductName")
    product_sku_code: Optional[StrictStr] = Field(default=None, alias="ProductSkuCode")
    product_type: Optional[StrictStr] = Field(default=None, alias="ProductType")
    relational_data: Optional[ClientDescribeInstanceResponseBodyRelationalData] = Field(default=None, alias="RelationalData")
    status: Optional[StrictStr] = Field(default=None, alias="Status")
    supplier_name: Optional[StrictStr] = Field(default=None, alias="SupplierName")
    __properties: ClassVar[List[str]] = ["AppJson", "AutoRenewal", "BeganOn", "ComponentJson", "Constraints", "CreatedOn", "EndOn", "ExtendJson", "HostJson", "InstanceId", "IsTrial", "Modules", "OrderId", "ProductCode", "ProductName", "ProductSkuCode", "ProductType", "RelationalData", "Status", "SupplierName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientDescribeInstanceResponseBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of modules
        if self.modules:
            _dict['Modules'] = self.modules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relational_data
        if self.relational_data:
            _dict['RelationalData'] = self.relational_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientDescribeInstanceResponseBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AppJson": obj.get("AppJson"),
            "AutoRenewal": obj.get("AutoRenewal"),
            "BeganOn": obj.get("BeganOn"),
            "ComponentJson": obj.get("ComponentJson"),
            "Constraints": obj.get("Constraints"),
            "CreatedOn": obj.get("CreatedOn"),
            "EndOn": obj.get("EndOn"),
            "ExtendJson": obj.get("ExtendJson"),
            "HostJson": obj.get("HostJson"),
            "InstanceId": obj.get("InstanceId"),
            "IsTrial": obj.get("IsTrial"),
            "Modules": ClientDescribeInstanceResponseBodyModules.from_dict(obj["Modules"]) if obj.get("Modules") is not None else None,
            "OrderId": obj.get("OrderId"),
            "ProductCode": obj.get("ProductCode"),
            "ProductName": obj.get("ProductName"),
            "ProductSkuCode": obj.get("ProductSkuCode"),
            "ProductType": obj.get("ProductType"),
            "RelationalData": ClientDescribeInstanceResponseBodyRelationalData.from_dict(obj["RelationalData"]) if obj.get("RelationalData") is not None else None,
            "Status": obj.get("Status"),
            "SupplierName": obj.get("SupplierName")
        })
        return _obj


