# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.client_describe_instance_response_body_modules_module_properties_property_property_values import ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValues
from typing import Optional, Set
from typing_extensions import Self

class ClientDescribeInstanceResponseBodyModulesModulePropertiesProperty(BaseModel):
    """
    ClientDescribeInstanceResponseBodyModulesModulePropertiesProperty
    """ # noqa: E501
    display_unit: Optional[StrictStr] = Field(default=None, alias="DisplayUnit")
    key: Optional[StrictStr] = Field(default=None, alias="Key")
    name: Optional[StrictStr] = Field(default=None, alias="Name")
    property_values: Optional[ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValues] = Field(default=None, alias="PropertyValues")
    show_type: Optional[StrictStr] = Field(default=None, alias="ShowType")
    __properties: ClassVar[List[str]] = ["DisplayUnit", "Key", "Name", "PropertyValues", "ShowType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientDescribeInstanceResponseBodyModulesModulePropertiesProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of property_values
        if self.property_values:
            _dict['PropertyValues'] = self.property_values.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientDescribeInstanceResponseBodyModulesModulePropertiesProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "DisplayUnit": obj.get("DisplayUnit"),
            "Key": obj.get("Key"),
            "Name": obj.get("Name"),
            "PropertyValues": ClientDescribeInstanceResponseBodyModulesModulePropertiesPropertyPropertyValues.from_dict(obj["PropertyValues"]) if obj.get("PropertyValues") is not None else None,
            "ShowType": obj.get("ShowType")
        })
        return _obj


