# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.client_describe_order_response_body_instance_ids import ClientDescribeOrderResponseBodyInstanceIds
from suger_sdk_python.models.client_describe_order_response_body_supplier_telephones import ClientDescribeOrderResponseBodySupplierTelephones
from typing import Optional, Set
from typing_extensions import Self

class ClientDescribeOrderResponseBody(BaseModel):
    """
    ClientDescribeOrderResponseBody
    """ # noqa: E501
    account_quantity: Optional[StrictInt] = Field(default=None, alias="AccountQuantity")
    ali_uid: Optional[StrictInt] = Field(default=None, alias="AliUid")
    components: Optional[Dict[str, Any]] = Field(default=None, alias="Components")
    coupon_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="CouponPrice")
    created_on: Optional[StrictInt] = Field(default=None, alias="CreatedOn")
    instance_ids: Optional[ClientDescribeOrderResponseBodyInstanceIds] = Field(default=None, alias="InstanceIds")
    order_id: Optional[StrictInt] = Field(default=None, alias="OrderId")
    order_status: Optional[StrictStr] = Field(default=None, alias="OrderStatus")
    order_type: Optional[StrictStr] = Field(default=None, alias="OrderType")
    original_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="OriginalPrice")
    paid_on: Optional[StrictInt] = Field(default=None, alias="PaidOn")
    pay_status: Optional[StrictStr] = Field(default=None, alias="PayStatus")
    payment_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="PaymentPrice")
    period_type: Optional[StrictStr] = Field(default=None, alias="PeriodType")
    product_code: Optional[StrictStr] = Field(default=None, alias="ProductCode")
    product_name: Optional[StrictStr] = Field(default=None, alias="ProductName")
    product_sku_code: Optional[StrictStr] = Field(default=None, alias="ProductSkuCode")
    quantity: Optional[StrictInt] = Field(default=None, alias="Quantity")
    request_id: Optional[StrictStr] = Field(default=None, alias="RequestId")
    supplier_company_name: Optional[StrictStr] = Field(default=None, alias="SupplierCompanyName")
    supplier_telephones: Optional[ClientDescribeOrderResponseBodySupplierTelephones] = Field(default=None, alias="SupplierTelephones")
    total_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="TotalPrice")
    __properties: ClassVar[List[str]] = ["AccountQuantity", "AliUid", "Components", "CouponPrice", "CreatedOn", "InstanceIds", "OrderId", "OrderStatus", "OrderType", "OriginalPrice", "PaidOn", "PayStatus", "PaymentPrice", "PeriodType", "ProductCode", "ProductName", "ProductSkuCode", "Quantity", "RequestId", "SupplierCompanyName", "SupplierTelephones", "TotalPrice"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientDescribeOrderResponseBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of instance_ids
        if self.instance_ids:
            _dict['InstanceIds'] = self.instance_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of supplier_telephones
        if self.supplier_telephones:
            _dict['SupplierTelephones'] = self.supplier_telephones.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientDescribeOrderResponseBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AccountQuantity": obj.get("AccountQuantity"),
            "AliUid": obj.get("AliUid"),
            "Components": obj.get("Components"),
            "CouponPrice": obj.get("CouponPrice"),
            "CreatedOn": obj.get("CreatedOn"),
            "InstanceIds": ClientDescribeOrderResponseBodyInstanceIds.from_dict(obj["InstanceIds"]) if obj.get("InstanceIds") is not None else None,
            "OrderId": obj.get("OrderId"),
            "OrderStatus": obj.get("OrderStatus"),
            "OrderType": obj.get("OrderType"),
            "OriginalPrice": obj.get("OriginalPrice"),
            "PaidOn": obj.get("PaidOn"),
            "PayStatus": obj.get("PayStatus"),
            "PaymentPrice": obj.get("PaymentPrice"),
            "PeriodType": obj.get("PeriodType"),
            "ProductCode": obj.get("ProductCode"),
            "ProductName": obj.get("ProductName"),
            "ProductSkuCode": obj.get("ProductSkuCode"),
            "Quantity": obj.get("Quantity"),
            "RequestId": obj.get("RequestId"),
            "SupplierCompanyName": obj.get("SupplierCompanyName"),
            "SupplierTelephones": ClientDescribeOrderResponseBodySupplierTelephones.from_dict(obj["SupplierTelephones"]) if obj.get("SupplierTelephones") is not None else None,
            "TotalPrice": obj.get("TotalPrice")
        })
        return _obj


