# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.company_info import CompanyInfo
from suger_sdk_python.models.partner import Partner
from suger_sdk_python.models.payment_config import PaymentConfig
from typing import Optional, Set
from typing_extensions import Self

class CreateBuyerParams(BaseModel):
    """
    CreateBuyerParams
    """ # noqa: E501
    adyen_customer_id: Optional[StrictStr] = Field(default=None, description="Adyen customerId of this buyer. If not provided but Partner is ADYEN, will create a new customer on Adyen.", alias="adyenCustomerId")
    company_info: Optional[CompanyInfo] = Field(default=None, description="Optional. CompanyInfo of the buyer.", alias="companyInfo")
    customer_id: Optional[StrictStr] = Field(default=None, description="The customer ID to recognize the cloud marketplace buyer in your internal system.", alias="customerId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the buyer.")
    lago_customer_id: Optional[StrictStr] = Field(default=None, description="Optional. The Lago Customer ID of the buyer.", alias="lagoCustomerId")
    metronome_customer_id: Optional[StrictStr] = Field(default=None, description="Optional. The Metronome Customer ID of the buyer.", alias="metronomeCustomerId")
    name: Optional[StrictStr] = Field(default=None, description="The name of the buyer.")
    orb_customer_id: Optional[StrictStr] = Field(default=None, description="Optional. The Orb Customer ID of the buyer.", alias="orbCustomerId")
    partner: Optional[Partner] = Field(default=None, description="The channel partner where this buyer is billed. Only STRIPE & ADYEN are supported at the moment.")
    payment_config: Optional[PaymentConfig] = Field(default=None, description="Payment config for billing.", alias="paymentConfig")
    stripe_customer_id: Optional[StrictStr] = Field(default=None, description="Stripe customerId of this buyer. If not provided but Partner is STRIPE, will create a new customer on stripe.", alias="stripeCustomerId")
    __properties: ClassVar[List[str]] = ["adyenCustomerId", "companyInfo", "customerId", "description", "lagoCustomerId", "metronomeCustomerId", "name", "orbCustomerId", "partner", "paymentConfig", "stripeCustomerId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateBuyerParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of company_info
        if self.company_info:
            _dict['companyInfo'] = self.company_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_config
        if self.payment_config:
            _dict['paymentConfig'] = self.payment_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateBuyerParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "adyenCustomerId": obj.get("adyenCustomerId"),
            "companyInfo": CompanyInfo.from_dict(obj["companyInfo"]) if obj.get("companyInfo") is not None else None,
            "customerId": obj.get("customerId"),
            "description": obj.get("description"),
            "lagoCustomerId": obj.get("lagoCustomerId"),
            "metronomeCustomerId": obj.get("metronomeCustomerId"),
            "name": obj.get("name"),
            "orbCustomerId": obj.get("orbCustomerId"),
            "partner": obj.get("partner"),
            "paymentConfig": PaymentConfig.from_dict(obj["paymentConfig"]) if obj.get("paymentConfig") is not None else None,
            "stripeCustomerId": obj.get("stripeCustomerId")
        })
        return _obj


