# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.aws_channel_partner import AwsChannelPartner
from suger_sdk_python.models.aws_marketplace_agreement_v2 import AwsMarketplaceAgreementV2
from suger_sdk_python.models.azure_marketplace_subscription import AzureMarketplaceSubscription
from suger_sdk_python.models.billable_dimension import BillableDimension
from suger_sdk_python.models.billing_addon_record import BillingAddonRecord
from suger_sdk_python.models.billing_cycle import BillingCycle
from suger_sdk_python.models.client_describe_instance_response_body import ClientDescribeInstanceResponseBody
from suger_sdk_python.models.client_describe_order_response_body import ClientDescribeOrderResponseBody
from suger_sdk_python.models.commit_dimension import CommitDimension
from suger_sdk_python.models.eula_type import EulaType
from suger_sdk_python.models.gcp_marketplace_entitlement import GcpMarketplaceEntitlement
from suger_sdk_python.models.gcp_marketplace_product_purchase_option_spec import GcpMarketplaceProductPurchaseOptionSpec
from suger_sdk_python.models.metering_dimension import MeteringDimension
from suger_sdk_python.models.payment_installment import PaymentInstallment
from suger_sdk_python.models.payment_schedule_type import PaymentScheduleType
from suger_sdk_python.models.trial_config import TrialConfig
from suger_sdk_python.models.types_entitlement import TypesEntitlement
from typing import Optional, Set
from typing_extensions import Self

class EntitlementInfo(BaseModel):
    """
    EntitlementInfo
    """ # noqa: E501
    addons: Optional[List[BillingAddonRecord]] = Field(default=None, description="The addons for the entitlement.")
    alert_days_before_end: Optional[StrictInt] = Field(default=None, description="Alert days before the end of the entitlement", alias="alertDaysBeforeEnd")
    alibaba_entitlements: Optional[List[ClientDescribeInstanceResponseBody]] = Field(default=None, description="Nullable. Alibaba Entitlements from Alibaba Marketplace.", alias="alibabaEntitlements")
    alibaba_orders: Optional[List[ClientDescribeOrderResponseBody]] = Field(default=None, description="Nullable. Alibaba Orders from Alibaba Marketplace.", alias="alibabaOrders")
    auto_renew: Optional[StrictBool] = Field(default=None, description="Is this Entitlement Auto Renew enabled.", alias="autoRenew")
    aws_agreement: Optional[AwsMarketplaceAgreementV2] = Field(default=None, description="Nullable. AWS agreement from AWS Marketplace.", alias="awsAgreement")
    aws_channel_partner: Optional[AwsChannelPartner] = Field(default=None, description="The AWS channel partner (reseller), only applicable if this entitlement is based on AWS CPPO offer.", alias="awsChannelPartner")
    aws_entitlements: Optional[List[TypesEntitlement]] = Field(default=None, description="Nullable. AWS Entitlements from AWS Marketplace.", alias="awsEntitlements")
    azure_subscriptions: Optional[List[AzureMarketplaceSubscription]] = Field(default=None, description="Nullable. Azure Subscriptions from Azure Marketplace.", alias="azureSubscriptions")
    billable_dimensions: Optional[List[BillableDimension]] = Field(default=None, description="The dimensions for billable metric usage-based metering. It's for Suger(Stripe, Ayden) metering.", alias="billableDimensions")
    billing_cycle: Optional[BillingCycle] = Field(default=None, description="Billing Cycle", alias="billingCycle")
    collectable_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount that the seller can collect. It excludes the marketplace commision fee.", alias="collectableAmount")
    commit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount that the buyer has committed to pay. It can be the sum of payment installments if applicable.", alias="commitAmount")
    commits: Optional[List[CommitDimension]] = Field(default=None, description="The dimensions for flatrate commitment (recurring or one-time).")
    currency: Optional[StrictStr] = Field(default=None, description="The default Currency is USD.")
    dimensions: Optional[List[MeteringDimension]] = Field(default=None, description="The dimensions for usage-based metering. It's for usage metering in cloud marketplaces. The max size of dimensions is 50. The oversized dimensions won't be saved in the EntitlementInfo. But the dimensions can be accessed from the connected offer info or product info.")
    dimensions_oversized: Optional[StrictBool] = Field(default=None, description="Whether the upper metering dimensions are oversized (exceed the max size 50).", alias="dimensionsOversized")
    disbursed_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount that has been disbursed to the seller account.", alias="disbursedAmount")
    eula_type: Optional[EulaType] = Field(default=None, alias="eulaType")
    eula_url: Optional[StrictStr] = Field(default=None, alias="eulaUrl")
    gcp_entitlements: Optional[List[GcpMarketplaceEntitlement]] = Field(default=None, description="Nullable. GCP Entitlements from GCP Marketplace.", alias="gcpEntitlements")
    gcp_plans: Optional[List[GcpMarketplaceProductPurchaseOptionSpec]] = Field(default=None, description="Only applicable for GCP Marketplace Entitlements.", alias="gcpPlans")
    grace_period_in_days: Optional[StrictInt] = Field(default=None, description="The grace period for the offer. It is same as the TrialConfig in DirectOfferInfo. But can be overridden at the entitlement level.", alias="gracePeriodInDays")
    gross_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The gross amount that the buyer has committed to pay, including usage metered amount.", alias="grossAmount")
    invoiced_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount that the buyer has got invoiced.", alias="invoicedAmount")
    net_terms_in_days: Optional[StrictInt] = Field(default=None, description="The net terms for the offer. It is same as the TrialConfig in DirectOfferInfo. But can be overridden at the entitlement level.", alias="netTermsInDays")
    payment_installments: Optional[List[PaymentInstallment]] = Field(default=None, description="For flexible payment schedules", alias="paymentInstallments")
    payment_schedule: Optional[PaymentScheduleType] = Field(default=None, description="The payment schedule for the entitlement. PREPAY means the buyer pays before the service is provided. POSTPAY means the buyer pays after the service is provided.", alias="paymentSchedule")
    refund_cancellation_policy: Optional[StrictStr] = Field(default=None, alias="refundCancellationPolicy")
    seller_notes: Optional[StrictStr] = Field(default=None, alias="sellerNotes")
    spa_url: Optional[StrictStr] = Field(default=None, description="The URL with JWT as auth method for the entitlement SPA. It can be shared with the buyer to access the SPA without login.", alias="spaUrl")
    trial_config: Optional[TrialConfig] = Field(default=None, description="The trial configuration for the offer. It is same as the TrialConfig in DirectOfferInfo. But can be overridden at the entitlement level.", alias="trialConfig")
    __properties: ClassVar[List[str]] = ["addons", "alertDaysBeforeEnd", "alibabaEntitlements", "alibabaOrders", "autoRenew", "awsAgreement", "awsChannelPartner", "awsEntitlements", "azureSubscriptions", "billableDimensions", "billingCycle", "collectableAmount", "commitAmount", "commits", "currency", "dimensions", "dimensionsOversized", "disbursedAmount", "eulaType", "eulaUrl", "gcpEntitlements", "gcpPlans", "gracePeriodInDays", "grossAmount", "invoicedAmount", "netTermsInDays", "paymentInstallments", "paymentSchedule", "refundCancellationPolicy", "sellerNotes", "spaUrl", "trialConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EntitlementInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in addons (list)
        _items = []
        if self.addons:
            for _item_addons in self.addons:
                if _item_addons:
                    _items.append(_item_addons.to_dict())
            _dict['addons'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in alibaba_entitlements (list)
        _items = []
        if self.alibaba_entitlements:
            for _item_alibaba_entitlements in self.alibaba_entitlements:
                if _item_alibaba_entitlements:
                    _items.append(_item_alibaba_entitlements.to_dict())
            _dict['alibabaEntitlements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in alibaba_orders (list)
        _items = []
        if self.alibaba_orders:
            for _item_alibaba_orders in self.alibaba_orders:
                if _item_alibaba_orders:
                    _items.append(_item_alibaba_orders.to_dict())
            _dict['alibabaOrders'] = _items
        # override the default output from pydantic by calling `to_dict()` of aws_agreement
        if self.aws_agreement:
            _dict['awsAgreement'] = self.aws_agreement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aws_channel_partner
        if self.aws_channel_partner:
            _dict['awsChannelPartner'] = self.aws_channel_partner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in aws_entitlements (list)
        _items = []
        if self.aws_entitlements:
            for _item_aws_entitlements in self.aws_entitlements:
                if _item_aws_entitlements:
                    _items.append(_item_aws_entitlements.to_dict())
            _dict['awsEntitlements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in azure_subscriptions (list)
        _items = []
        if self.azure_subscriptions:
            for _item_azure_subscriptions in self.azure_subscriptions:
                if _item_azure_subscriptions:
                    _items.append(_item_azure_subscriptions.to_dict())
            _dict['azureSubscriptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in billable_dimensions (list)
        _items = []
        if self.billable_dimensions:
            for _item_billable_dimensions in self.billable_dimensions:
                if _item_billable_dimensions:
                    _items.append(_item_billable_dimensions.to_dict())
            _dict['billableDimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item_commits in self.commits:
                if _item_commits:
                    _items.append(_item_commits.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dimensions (list)
        _items = []
        if self.dimensions:
            for _item_dimensions in self.dimensions:
                if _item_dimensions:
                    _items.append(_item_dimensions.to_dict())
            _dict['dimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in gcp_entitlements (list)
        _items = []
        if self.gcp_entitlements:
            for _item_gcp_entitlements in self.gcp_entitlements:
                if _item_gcp_entitlements:
                    _items.append(_item_gcp_entitlements.to_dict())
            _dict['gcpEntitlements'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in gcp_plans (list)
        _items = []
        if self.gcp_plans:
            for _item_gcp_plans in self.gcp_plans:
                if _item_gcp_plans:
                    _items.append(_item_gcp_plans.to_dict())
            _dict['gcpPlans'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_installments (list)
        _items = []
        if self.payment_installments:
            for _item_payment_installments in self.payment_installments:
                if _item_payment_installments:
                    _items.append(_item_payment_installments.to_dict())
            _dict['paymentInstallments'] = _items
        # override the default output from pydantic by calling `to_dict()` of trial_config
        if self.trial_config:
            _dict['trialConfig'] = self.trial_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EntitlementInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addons": [BillingAddonRecord.from_dict(_item) for _item in obj["addons"]] if obj.get("addons") is not None else None,
            "alertDaysBeforeEnd": obj.get("alertDaysBeforeEnd"),
            "alibabaEntitlements": [ClientDescribeInstanceResponseBody.from_dict(_item) for _item in obj["alibabaEntitlements"]] if obj.get("alibabaEntitlements") is not None else None,
            "alibabaOrders": [ClientDescribeOrderResponseBody.from_dict(_item) for _item in obj["alibabaOrders"]] if obj.get("alibabaOrders") is not None else None,
            "autoRenew": obj.get("autoRenew"),
            "awsAgreement": AwsMarketplaceAgreementV2.from_dict(obj["awsAgreement"]) if obj.get("awsAgreement") is not None else None,
            "awsChannelPartner": AwsChannelPartner.from_dict(obj["awsChannelPartner"]) if obj.get("awsChannelPartner") is not None else None,
            "awsEntitlements": [TypesEntitlement.from_dict(_item) for _item in obj["awsEntitlements"]] if obj.get("awsEntitlements") is not None else None,
            "azureSubscriptions": [AzureMarketplaceSubscription.from_dict(_item) for _item in obj["azureSubscriptions"]] if obj.get("azureSubscriptions") is not None else None,
            "billableDimensions": [BillableDimension.from_dict(_item) for _item in obj["billableDimensions"]] if obj.get("billableDimensions") is not None else None,
            "billingCycle": obj.get("billingCycle"),
            "collectableAmount": obj.get("collectableAmount"),
            "commitAmount": obj.get("commitAmount"),
            "commits": [CommitDimension.from_dict(_item) for _item in obj["commits"]] if obj.get("commits") is not None else None,
            "currency": obj.get("currency"),
            "dimensions": [MeteringDimension.from_dict(_item) for _item in obj["dimensions"]] if obj.get("dimensions") is not None else None,
            "dimensionsOversized": obj.get("dimensionsOversized"),
            "disbursedAmount": obj.get("disbursedAmount"),
            "eulaType": obj.get("eulaType"),
            "eulaUrl": obj.get("eulaUrl"),
            "gcpEntitlements": [GcpMarketplaceEntitlement.from_dict(_item) for _item in obj["gcpEntitlements"]] if obj.get("gcpEntitlements") is not None else None,
            "gcpPlans": [GcpMarketplaceProductPurchaseOptionSpec.from_dict(_item) for _item in obj["gcpPlans"]] if obj.get("gcpPlans") is not None else None,
            "gracePeriodInDays": obj.get("gracePeriodInDays"),
            "grossAmount": obj.get("grossAmount"),
            "invoicedAmount": obj.get("invoicedAmount"),
            "netTermsInDays": obj.get("netTermsInDays"),
            "paymentInstallments": [PaymentInstallment.from_dict(_item) for _item in obj["paymentInstallments"]] if obj.get("paymentInstallments") is not None else None,
            "paymentSchedule": obj.get("paymentSchedule"),
            "refundCancellationPolicy": obj.get("refundCancellationPolicy"),
            "sellerNotes": obj.get("sellerNotes"),
            "spaUrl": obj.get("spaUrl"),
            "trialConfig": TrialConfig.from_dict(obj["trialConfig"]) if obj.get("trialConfig") is not None else None
        })
        return _obj


