# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_amount_unit import GcpAmountUnit
from typing import Optional, Set
from typing_extensions import Self

class GcpAmountConstraint(BaseModel):
    """
    GcpAmountConstraint
    """ # noqa: E501
    default_amount: Optional[GcpAmountUnit] = Field(default=None, alias="defaultAmount")
    max_amount: Optional[GcpAmountUnit] = Field(default=None, alias="maxAmount")
    min_amount: Optional[GcpAmountUnit] = Field(default=None, alias="minAmount")
    __properties: ClassVar[List[str]] = ["defaultAmount", "maxAmount", "minAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpAmountConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_amount
        if self.default_amount:
            _dict['defaultAmount'] = self.default_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_amount
        if self.max_amount:
            _dict['maxAmount'] = self.max_amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of min_amount
        if self.min_amount:
            _dict['minAmount'] = self.min_amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpAmountConstraint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultAmount": GcpAmountUnit.from_dict(obj["defaultAmount"]) if obj.get("defaultAmount") is not None else None,
            "maxAmount": GcpAmountUnit.from_dict(obj["maxAmount"]) if obj.get("maxAmount") is not None else None,
            "minAmount": GcpAmountUnit.from_dict(obj["minAmount"]) if obj.get("minAmount") is not None else None
        })
        return _obj


