# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_external_google_link import GcpMarketplaceExternalGoogleLink
from suger_sdk_python.models.gcp_marketplace_unstructured_document import GcpMarketplaceUnstructuredDocument
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceDocument(BaseModel):
    """
    GcpMarketplaceDocument
    """ # noqa: E501
    description: Optional[StrictStr] = None
    document_body: Optional[StrictStr] = Field(default=None, alias="documentBody")
    document_type: Optional[StrictStr] = Field(default=None, description="such as \"PARTNER_EULA\"", alias="documentType")
    external_google_link: Optional[GcpMarketplaceExternalGoogleLink] = Field(default=None, description="The external link to Standard EULA such as https://cloud.google.com/terms/marketplace/eula-standard-v2-01272021.", alias="externalGoogleLink")
    name: Optional[StrictStr] = Field(default=None, description="in format of \"projects/{projectNumber}/agreements/{agreementId}/documents/{documentId}\"")
    unstructured_document: Optional[GcpMarketplaceUnstructuredDocument] = Field(default=None, alias="unstructuredDocument")
    update_time: Optional[datetime] = Field(default=None, alias="updateTime")
    __properties: ClassVar[List[str]] = ["description", "documentBody", "documentType", "externalGoogleLink", "name", "unstructuredDocument", "updateTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of external_google_link
        if self.external_google_link:
            _dict['externalGoogleLink'] = self.external_google_link.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unstructured_document
        if self.unstructured_document:
            _dict['unstructuredDocument'] = self.unstructured_document.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "documentBody": obj.get("documentBody"),
            "documentType": obj.get("documentType"),
            "externalGoogleLink": GcpMarketplaceExternalGoogleLink.from_dict(obj["externalGoogleLink"]) if obj.get("externalGoogleLink") is not None else None,
            "name": obj.get("name"),
            "unstructuredDocument": GcpMarketplaceUnstructuredDocument.from_dict(obj["unstructuredDocument"]) if obj.get("unstructuredDocument") is not None else None,
            "updateTime": obj.get("updateTime")
        })
        return _obj


