# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_consumer import GcpMarketplaceConsumer
from suger_sdk_python.models.gcp_marketplace_entitlement_state import GcpMarketplaceEntitlementState
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceEntitlement(BaseModel):
    """
    GcpMarketplaceEntitlement
    """ # noqa: E501
    account: Optional[StrictStr] = Field(default=None, description="The resource name of the account that this entitlement is based on, if any, in format \"\"providers/{provider_id}/accounts/{account_id}\"")
    consumers: Optional[List[GcpMarketplaceConsumer]] = Field(default=None, description="The resources using this entitlement, if applicable.")
    create_time: Optional[datetime] = Field(default=None, alias="createTime")
    id: Optional[StrictStr] = Field(default=None, description="Entitlement Id generated by GCP Marketplace. For Marketplace pub/sub event.")
    input_properties: Optional[List[StrictInt]] = Field(default=None, description="The custom properties that were collected from the user to create this entitlement.", alias="inputProperties")
    message_to_user: Optional[StrictStr] = Field(default=None, description="Provider-supplied message that is displayed to the end user. Currently this is used to communicate progress and ETA for provisioning. This field can be updated only when a user is waiting for an action from the provider, i.e. entitlement state is EntitlementState.ENTITLEMENT_ACTIVATION_REQUESTED or EntitlementState.ENTITLEMENT_PENDING_PLAN_CHANGE_APPROVAL. This field is cleared automatically when the entitlement state changes.", alias="messageToUser")
    name: Optional[StrictStr] = Field(default=None, description="The resource name of the entitlement. Entitlement names have the form of `providers/{provider_id}/entitlements/{entitlement_id}`.")
    new_offer_duration: Optional[StrictStr] = Field(default=None, description="in ISO 8601 duration format, such as \"P2Y3M\". For Marketplace pub/sub event.", alias="newOfferDuration")
    new_offer_end_time: Optional[StrictStr] = Field(default=None, description="Output only. The end time of the new offer. Field is empty if the pending plan change is not moving to an offer. If the offer was created with a term instead of a specified end date, this field is empty.", alias="newOfferEndTime")
    new_offer_start_time: Optional[StrictStr] = Field(default=None, description="Output only. The start time of the new offer. Field is empty if the pending plan change is not moving to an offer.", alias="newOfferStartTime")
    new_pending_offer: Optional[StrictStr] = Field(default=None, description="The name of the offer the entitlement is switching to upon a pending plan change. Only exists if the pending plan change is moving to an offer. Format: 'projects/{project}/services/{service}/privateOffers/{offer-id}' OR 'projects/{project}/services/{service}/standardOffers/{offer-id}', depending on whether the offer is private or public.", alias="newPendingOffer")
    new_pending_offer_duration: Optional[StrictStr] = Field(default=None, description="The offer duration of the new offer in ISO 8601 duration format. Field is empty if the pending plan change is not moving to an offer since the entitlement is not pending, only the plan change is pending.", alias="newPendingOfferDuration")
    new_pending_plan: Optional[StrictStr] = Field(default=None, description="The identifier of the pending new plan. Required if the product has plans and the entitlement has a pending plan change.", alias="newPendingPlan")
    new_plan: Optional[StrictStr] = Field(default=None, description="When the buyer changes plan, For Marketplace pub/sub event.", alias="newPlan")
    offer: Optional[StrictStr] = Field(default=None, description="The name of the offer that was procured. Field is empty if order was not made using an offer. Format: 'projects/{project}/services/{service}/privateOffers/{offer-id}' OR 'projects/{project}/services/{service}/standardOffers/{offer-id}', depending on whether the offer is private or public.")
    offer_duration: Optional[StrictStr] = Field(default=None, description="The offer duration of the current offer in ISO 8601 duration format. Field is empty if entitlement was not made using an offer, such as \"P1Y\", \"P2M\"", alias="offerDuration")
    offer_effective_time: Optional[datetime] = Field(default=None, description="When the offer is effective.", alias="offerEffectiveTime")
    offer_end_time: Optional[datetime] = Field(default=None, description="Output only. End time for the Offer association corresponding to this entitlement. The field is only populated if the entitlement is currently associated with an Offer.", alias="offerEndTime")
    plan: Optional[StrictStr] = Field(default=None, description="The identifier of the plan that was procured. Required if the product has plans.")
    product: Optional[StrictStr] = Field(default=None, description="The identifier of the entity that was purchased. This may actually represent a product, quote, or offer. For Private offer, \"projects/project-id/services/product-id.endpoints.partner-id.cloud.goog/privateOffers/private-offer-id\"")
    product_external_name: Optional[StrictStr] = Field(default=None, description="The identifier of the product that was procured.", alias="productExternalName")
    provider: Optional[StrictStr] = Field(default=None, description="The ID of the service provider under Cloud Commerce platform that this entitlement was created against.")
    quote_external_name: Optional[StrictStr] = Field(default=None, description="The identifier of the quote that was used to procure, such as the private offer Id. Empty if the order is not purchased using a quote.", alias="quoteExternalName")
    state: Optional[GcpMarketplaceEntitlementState] = Field(default=None, description="Enums of the Entitlement State. https://cloud.google.com/marketplace/docs/partners/commerce-procurement-api/reference/rest/v1/providers.entitlements#EntitlementState")
    subscription_end_time: Optional[datetime] = Field(default=None, description="The End time for the subscription corresponding to this entitlement.", alias="subscriptionEndTime")
    update_time: Optional[datetime] = Field(default=None, description="The last update timestamp. It is the endTime for the cancelled entitlement.", alias="updateTime")
    usage_reporting_id: Optional[StrictStr] = Field(default=None, description="The consumerId to use when reporting usage through the Service Control API. See the consumerId field at Reporting Metrics (https://cloud.google.com/service-control/reporting-metrics) for more details. This field is present only if the product has usage-based billing configured.", alias="usageReportingId")
    __properties: ClassVar[List[str]] = ["account", "consumers", "createTime", "id", "inputProperties", "messageToUser", "name", "newOfferDuration", "newOfferEndTime", "newOfferStartTime", "newPendingOffer", "newPendingOfferDuration", "newPendingPlan", "newPlan", "offer", "offerDuration", "offerEffectiveTime", "offerEndTime", "plan", "product", "productExternalName", "provider", "quoteExternalName", "state", "subscriptionEndTime", "updateTime", "usageReportingId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceEntitlement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in consumers (list)
        _items = []
        if self.consumers:
            for _item_consumers in self.consumers:
                if _item_consumers:
                    _items.append(_item_consumers.to_dict())
            _dict['consumers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceEntitlement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account": obj.get("account"),
            "consumers": [GcpMarketplaceConsumer.from_dict(_item) for _item in obj["consumers"]] if obj.get("consumers") is not None else None,
            "createTime": obj.get("createTime"),
            "id": obj.get("id"),
            "inputProperties": obj.get("inputProperties"),
            "messageToUser": obj.get("messageToUser"),
            "name": obj.get("name"),
            "newOfferDuration": obj.get("newOfferDuration"),
            "newOfferEndTime": obj.get("newOfferEndTime"),
            "newOfferStartTime": obj.get("newOfferStartTime"),
            "newPendingOffer": obj.get("newPendingOffer"),
            "newPendingOfferDuration": obj.get("newPendingOfferDuration"),
            "newPendingPlan": obj.get("newPendingPlan"),
            "newPlan": obj.get("newPlan"),
            "offer": obj.get("offer"),
            "offerDuration": obj.get("offerDuration"),
            "offerEffectiveTime": obj.get("offerEffectiveTime"),
            "offerEndTime": obj.get("offerEndTime"),
            "plan": obj.get("plan"),
            "product": obj.get("product"),
            "productExternalName": obj.get("productExternalName"),
            "provider": obj.get("provider"),
            "quoteExternalName": obj.get("quoteExternalName"),
            "state": obj.get("state"),
            "subscriptionEndTime": obj.get("subscriptionEndTime"),
            "updateTime": obj.get("updateTime"),
            "usageReportingId": obj.get("usageReportingId")
        })
        return _obj


