# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_entitlement import GcpMarketplaceEntitlement
from suger_sdk_python.models.gcp_marketplace_existing_private_offer import GcpMarketplaceExistingPrivateOffer
from suger_sdk_python.models.gcp_marketplace_private_offer_price_model_type import GcpMarketplacePrivateOfferPriceModelType
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceExistingOfferData(BaseModel):
    """
    GcpMarketplaceExistingOfferData
    """ # noqa: E501
    entitlement: Optional[GcpMarketplaceEntitlement] = None
    existing_price_model_type: Optional[GcpMarketplacePrivateOfferPriceModelType] = Field(default=None, alias="existingPriceModelType")
    has_entitlement_changed: Optional[StrictBool] = Field(default=None, alias="hasEntitlementChanged")
    private_offer: Optional[GcpMarketplaceExistingPrivateOffer] = Field(default=None, alias="privateOffer")
    standard_offer: Optional[Dict[str, Any]] = Field(default=None, alias="standardOffer")
    __properties: ClassVar[List[str]] = ["entitlement", "existingPriceModelType", "hasEntitlementChanged", "privateOffer", "standardOffer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceExistingOfferData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entitlement
        if self.entitlement:
            _dict['entitlement'] = self.entitlement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of private_offer
        if self.private_offer:
            _dict['privateOffer'] = self.private_offer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceExistingOfferData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "entitlement": GcpMarketplaceEntitlement.from_dict(obj["entitlement"]) if obj.get("entitlement") is not None else None,
            "existingPriceModelType": obj.get("existingPriceModelType"),
            "hasEntitlementChanged": obj.get("hasEntitlementChanged"),
            "privateOffer": GcpMarketplaceExistingPrivateOffer.from_dict(obj["privateOffer"]) if obj.get("privateOffer") is not None else None,
            "standardOffer": obj.get("standardOffer")
        })
        return _obj


