# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_document import GcpMarketplaceDocument
from suger_sdk_python.models.gcp_marketplace_private_offer_installment_timeline import GcpMarketplacePrivateOfferInstallmentTimeline
from suger_sdk_python.models.gcp_marketplace_private_offer_price_model import GcpMarketplacePrivateOfferPriceModel
from suger_sdk_python.models.gcp_marketplace_private_offer_term import GcpMarketplacePrivateOfferTerm
from suger_sdk_python.models.payment_schedule_type import PaymentScheduleType
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceExistingPrivateOffer(BaseModel):
    """
    GcpMarketplaceExistingPrivateOffer
    """ # noqa: E501
    agreement: Optional[StrictStr] = None
    custom_eula: Optional[GcpMarketplaceDocument] = Field(default=None, alias="customEula")
    installment_timeline: Optional[GcpMarketplacePrivateOfferInstallmentTimeline] = Field(default=None, alias="installmentTimeline")
    name: Optional[StrictStr] = Field(default=None, description="GCP private offer resource name.")
    offer_term: Optional[GcpMarketplacePrivateOfferTerm] = Field(default=None, alias="offerTerm")
    payment_schedule: Optional[PaymentScheduleType] = Field(default=None, alias="paymentSchedule")
    price_model: Optional[GcpMarketplacePrivateOfferPriceModel] = Field(default=None, description="Nill if the offer has payment installments.", alias="priceModel")
    service_level: Optional[StrictStr] = Field(default=None, description="The Plan of the offer.", alias="serviceLevel")
    __properties: ClassVar[List[str]] = ["agreement", "customEula", "installmentTimeline", "name", "offerTerm", "paymentSchedule", "priceModel", "serviceLevel"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceExistingPrivateOffer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of custom_eula
        if self.custom_eula:
            _dict['customEula'] = self.custom_eula.to_dict()
        # override the default output from pydantic by calling `to_dict()` of installment_timeline
        if self.installment_timeline:
            _dict['installmentTimeline'] = self.installment_timeline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of offer_term
        if self.offer_term:
            _dict['offerTerm'] = self.offer_term.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model
        if self.price_model:
            _dict['priceModel'] = self.price_model.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceExistingPrivateOffer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "agreement": obj.get("agreement"),
            "customEula": GcpMarketplaceDocument.from_dict(obj["customEula"]) if obj.get("customEula") is not None else None,
            "installmentTimeline": GcpMarketplacePrivateOfferInstallmentTimeline.from_dict(obj["installmentTimeline"]) if obj.get("installmentTimeline") is not None else None,
            "name": obj.get("name"),
            "offerTerm": GcpMarketplacePrivateOfferTerm.from_dict(obj["offerTerm"]) if obj.get("offerTerm") is not None else None,
            "paymentSchedule": obj.get("paymentSchedule"),
            "priceModel": GcpMarketplacePrivateOfferPriceModel.from_dict(obj["priceModel"]) if obj.get("priceModel") is not None else None,
            "serviceLevel": obj.get("serviceLevel")
        })
        return _obj


