# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_metering_metric_value_set import GcpMarketplaceMeteringMetricValueSet
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceMeteringOperation(BaseModel):
    """
    GcpMarketplaceMeteringOperation
    """ # noqa: E501
    consumer_id: Optional[StrictStr] = Field(default=None, description="ConsumerId: Identity of the consumer who is using the service. This field should be filled in for the operations initiated by a consumer, but not for service-initiated operations that are not related to a specific consumer. - This can be in one of the following formats: - project:PROJECT_ID, - project`_`number:PROJECT_NUMBER, - projects/PROJECT_ID or PROJECT_NUMBER, - folders/FOLDER_NUMBER, - organizations/ORGANIZATION_NUMBER, - api`_`key:API_KEY.", alias="consumerId")
    end_time: Optional[StrictStr] = Field(default=None, description="EndTime: End time of the operation. Required when the operation is used in ServiceController.Report, but optional when the operation is used in ServiceController.Check.", alias="endTime")
    labels: Optional[Dict[str, StrictStr]] = Field(default=None, description="Labels: Labels describing the operation. Only the following labels are allowed: - Labels describing monitored resources as defined in the service configuration. - Default labels of metric values. When specified, labels defined in the metric value override these default. - The following labels defined by Google Cloud Platform: - `cloud.googleapis.com/location` describing the location where the operation happened, - `servicecontrol.googleapis.com/user_agent` describing the user agent of the API request, - `servicecontrol.googleapis.com/service_agent` describing the service used to handle the API request (e.g. ESP), - `servicecontrol.googleapis.com/platform` describing the platform where the API is served, such as App Engine, Compute Engine, or Kubernetes Engine.")
    metric_value_sets: Optional[List[GcpMarketplaceMeteringMetricValueSet]] = Field(default=None, description="MetricValueSets: Represents information about this operation. Each MetricValueSet corresponds to a metric defined in the service configuration. The data type used in the MetricValueSet must agree with the data type specified in the metric definition. Within a single operation, it is not allowed to have more than one MetricValue instances that have the same metric names and identical label value combinations. If a request has such duplicated MetricValue instances, the entire request is rejected with an invalid argument error.", alias="metricValueSets")
    operation_id: Optional[StrictStr] = Field(default=None, description="OperationId: Identity of the operation. This must be unique within the scope of the service that generated the operation. If the service calls Check() and Report() on the same operation, the two calls should carry the same id. UUID version 4 is recommended, though not required. In scenarios where an operation is computed from existing information and an idempotent id is desirable for deduplication purpose, UUID version 5 is recommended. See RFC 4122 for details.", alias="operationId")
    operation_name: Optional[StrictStr] = Field(default=None, description="OperationName: Fully qualified name of the operation. Reserved for future use.", alias="operationName")
    start_time: Optional[StrictStr] = Field(default=None, description="StartTime: Required. Start time of the operation.", alias="startTime")
    __properties: ClassVar[List[str]] = ["consumerId", "endTime", "labels", "metricValueSets", "operationId", "operationName", "startTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceMeteringOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in metric_value_sets (list)
        _items = []
        if self.metric_value_sets:
            for _item_metric_value_sets in self.metric_value_sets:
                if _item_metric_value_sets:
                    _items.append(_item_metric_value_sets.to_dict())
            _dict['metricValueSets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceMeteringOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "consumerId": obj.get("consumerId"),
            "endTime": obj.get("endTime"),
            "labels": obj.get("labels"),
            "metricValueSets": [GcpMarketplaceMeteringMetricValueSet.from_dict(_item) for _item in obj["metricValueSets"]] if obj.get("metricValueSets") is not None else None,
            "operationId": obj.get("operationId"),
            "operationName": obj.get("operationName"),
            "startTime": obj.get("startTime")
        })
        return _obj


