# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_document import GcpMarketplaceDocument
from suger_sdk_python.models.gcp_marketplace_entitlement import GcpMarketplaceEntitlement
from suger_sdk_python.models.gcp_marketplace_existing_offer_data import GcpMarketplaceExistingOfferData
from suger_sdk_python.models.gcp_marketplace_private_offer_customer_info import GcpMarketplacePrivateOfferCustomerInfo
from suger_sdk_python.models.gcp_marketplace_private_offer_installment_timeline import GcpMarketplacePrivateOfferInstallmentTimeline
from suger_sdk_python.models.gcp_marketplace_private_offer_metric_information import GcpMarketplacePrivateOfferMetricInformation
from suger_sdk_python.models.gcp_marketplace_private_offer_migration_metadata import GcpMarketplacePrivateOfferMigrationMetadata
from suger_sdk_python.models.gcp_marketplace_private_offer_price_model import GcpMarketplacePrivateOfferPriceModel
from suger_sdk_python.models.gcp_marketplace_private_offer_price_model_type import GcpMarketplacePrivateOfferPriceModelType
from suger_sdk_python.models.gcp_marketplace_private_offer_provider_info import GcpMarketplacePrivateOfferProviderInfo
from suger_sdk_python.models.gcp_marketplace_private_offer_replacement_metadata import GcpMarketplacePrivateOfferReplacementMetadata
from suger_sdk_python.models.gcp_marketplace_private_offer_state import GcpMarketplacePrivateOfferState
from suger_sdk_python.models.gcp_marketplace_private_offer_term import GcpMarketplacePrivateOfferTerm
from suger_sdk_python.models.gcp_marketplace_product_feature_value import GcpMarketplaceProductFeatureValue
from suger_sdk_python.models.gcp_marketplace_purchase_channel import GcpMarketplacePurchaseChannel
from suger_sdk_python.models.gcp_marketplace_reseller_info import GcpMarketplaceResellerInfo
from suger_sdk_python.models.payment_schedule_type import PaymentScheduleType
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplacePrivateOffer(BaseModel):
    """
    GcpMarketplacePrivateOffer
    """ # noqa: E501
    active_entitlement: Optional[GcpMarketplaceEntitlement] = Field(default=None, alias="activeEntitlement")
    agency_enabled: Optional[StrictBool] = Field(default=None, alias="agencyEnabled")
    agreement: Optional[StrictStr] = Field(default=None, description="The resource name of agreement(entitlement) In format of \"projects/{projectNumber}/agreements/{agreementId}\"")
    cancel_time: Optional[datetime] = Field(default=None, alias="cancelTime")
    custom_eula: Optional[GcpMarketplaceDocument] = Field(default=None, alias="customEula")
    customer_info: Optional[GcpMarketplacePrivateOfferCustomerInfo] = Field(default=None, alias="customerInfo")
    eula_agreement_document: Optional[GcpMarketplaceDocument] = Field(default=None, alias="eulaAgreementDocument")
    existing_offer_data: Optional[GcpMarketplaceExistingOfferData] = Field(default=None, alias="existingOfferData")
    expire_time: Optional[datetime] = Field(default=None, alias="expireTime")
    features: Optional[List[GcpMarketplaceProductFeatureValue]] = None
    installment_timeline: Optional[GcpMarketplacePrivateOfferInstallmentTimeline] = Field(default=None, alias="installmentTimeline")
    lifecycle_state: Optional[StrictStr] = Field(default=None, description="such as \"PUBLISHED\"", alias="lifecycleState")
    metric_information: Optional[GcpMarketplacePrivateOfferMetricInformation] = Field(default=None, alias="metricInformation")
    migration_metadata: Optional[GcpMarketplacePrivateOfferMigrationMetadata] = Field(default=None, alias="migrationMetadata")
    name: Optional[StrictStr] = Field(default=None, description="In format of \"projects/{projectNumber}/services/{serviceName, such as service-name.endpoints.gcp-project-id.cloud.goog}/privateOffers/{privateOfferId}\"")
    offer_id: Optional[StrictStr] = Field(default=None, description="GCP private offer ID", alias="offerId")
    offer_source: Optional[StrictStr] = Field(default=None, description="such as \"OFFER\" or \"RESOLD\" (resold via channel partner)", alias="offerSource")
    offer_state: Optional[GcpMarketplacePrivateOfferState] = Field(default=None, alias="offerState")
    offer_term: Optional[GcpMarketplacePrivateOfferTerm] = Field(default=None, alias="offerTerm")
    offer_title: Optional[StrictStr] = Field(default=None, description="The offer title in the GCP Marketplace.", alias="offerTitle")
    offer_title_auto_generated: Optional[StrictBool] = Field(default=None, alias="offerTitleAutoGenerated")
    payment_schedule: Optional[PaymentScheduleType] = Field(default=None, description="such as \"PREPAY\" or \"POSTPAY\"", alias="paymentSchedule")
    policies: Optional[Dict[str, StrictStr]] = None
    price_model: Optional[GcpMarketplacePrivateOfferPriceModel] = Field(default=None, description="Nill if the offer has payment installments.", alias="priceModel")
    price_model_type: Optional[GcpMarketplacePrivateOfferPriceModelType] = Field(default=None, alias="priceModelType")
    provider_cancellation_internal_note: Optional[StrictStr] = Field(default=None, alias="providerCancellationInternalNote")
    provider_info: Optional[GcpMarketplacePrivateOfferProviderInfo] = Field(default=None, alias="providerInfo")
    provider_internal_note: Optional[StrictStr] = Field(default=None, alias="providerInternalNote")
    provider_public_note: Optional[StrictStr] = Field(default=None, alias="providerPublicNote")
    purchase_channel: Optional[GcpMarketplacePurchaseChannel] = Field(default=None, alias="purchaseChannel")
    purchase_time: Optional[datetime] = Field(default=None, alias="purchaseTime")
    replacement_metadata: Optional[GcpMarketplacePrivateOfferReplacementMetadata] = Field(default=None, alias="replacementMetadata")
    reseller_info: Optional[GcpMarketplaceResellerInfo] = Field(default=None, description="The info of the reseller who resold the offer and when OfferSource is \"RESOLD\".", alias="resellerInfo")
    service_level: Optional[StrictStr] = Field(default=None, description="The Plan of the offer.", alias="serviceLevel")
    update_time: Optional[datetime] = Field(default=None, alias="updateTime")
    use_legacy_partner_eula: Optional[StrictBool] = Field(default=None, alias="useLegacyPartnerEula")
    user_labels: Optional[List[StrictStr]] = Field(default=None, alias="userLabels")
    __properties: ClassVar[List[str]] = ["activeEntitlement", "agencyEnabled", "agreement", "cancelTime", "customEula", "customerInfo", "eulaAgreementDocument", "existingOfferData", "expireTime", "features", "installmentTimeline", "lifecycleState", "metricInformation", "migrationMetadata", "name", "offerId", "offerSource", "offerState", "offerTerm", "offerTitle", "offerTitleAutoGenerated", "paymentSchedule", "policies", "priceModel", "priceModelType", "providerCancellationInternalNote", "providerInfo", "providerInternalNote", "providerPublicNote", "purchaseChannel", "purchaseTime", "replacementMetadata", "resellerInfo", "serviceLevel", "updateTime", "useLegacyPartnerEula", "userLabels"]

    @field_validator('offer_source')
    def offer_source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['OFFER', 'RESOLD']):
            raise ValueError("must be one of enum values ('OFFER', 'RESOLD')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOffer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of active_entitlement
        if self.active_entitlement:
            _dict['activeEntitlement'] = self.active_entitlement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of custom_eula
        if self.custom_eula:
            _dict['customEula'] = self.custom_eula.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer_info
        if self.customer_info:
            _dict['customerInfo'] = self.customer_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eula_agreement_document
        if self.eula_agreement_document:
            _dict['eulaAgreementDocument'] = self.eula_agreement_document.to_dict()
        # override the default output from pydantic by calling `to_dict()` of existing_offer_data
        if self.existing_offer_data:
            _dict['existingOfferData'] = self.existing_offer_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in features (list)
        _items = []
        if self.features:
            for _item_features in self.features:
                if _item_features:
                    _items.append(_item_features.to_dict())
            _dict['features'] = _items
        # override the default output from pydantic by calling `to_dict()` of installment_timeline
        if self.installment_timeline:
            _dict['installmentTimeline'] = self.installment_timeline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metric_information
        if self.metric_information:
            _dict['metricInformation'] = self.metric_information.to_dict()
        # override the default output from pydantic by calling `to_dict()` of migration_metadata
        if self.migration_metadata:
            _dict['migrationMetadata'] = self.migration_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of offer_term
        if self.offer_term:
            _dict['offerTerm'] = self.offer_term.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model
        if self.price_model:
            _dict['priceModel'] = self.price_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provider_info
        if self.provider_info:
            _dict['providerInfo'] = self.provider_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of purchase_channel
        if self.purchase_channel:
            _dict['purchaseChannel'] = self.purchase_channel.to_dict()
        # override the default output from pydantic by calling `to_dict()` of replacement_metadata
        if self.replacement_metadata:
            _dict['replacementMetadata'] = self.replacement_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reseller_info
        if self.reseller_info:
            _dict['resellerInfo'] = self.reseller_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOffer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "activeEntitlement": GcpMarketplaceEntitlement.from_dict(obj["activeEntitlement"]) if obj.get("activeEntitlement") is not None else None,
            "agencyEnabled": obj.get("agencyEnabled"),
            "agreement": obj.get("agreement"),
            "cancelTime": obj.get("cancelTime"),
            "customEula": GcpMarketplaceDocument.from_dict(obj["customEula"]) if obj.get("customEula") is not None else None,
            "customerInfo": GcpMarketplacePrivateOfferCustomerInfo.from_dict(obj["customerInfo"]) if obj.get("customerInfo") is not None else None,
            "eulaAgreementDocument": GcpMarketplaceDocument.from_dict(obj["eulaAgreementDocument"]) if obj.get("eulaAgreementDocument") is not None else None,
            "existingOfferData": GcpMarketplaceExistingOfferData.from_dict(obj["existingOfferData"]) if obj.get("existingOfferData") is not None else None,
            "expireTime": obj.get("expireTime"),
            "features": [GcpMarketplaceProductFeatureValue.from_dict(_item) for _item in obj["features"]] if obj.get("features") is not None else None,
            "installmentTimeline": GcpMarketplacePrivateOfferInstallmentTimeline.from_dict(obj["installmentTimeline"]) if obj.get("installmentTimeline") is not None else None,
            "lifecycleState": obj.get("lifecycleState"),
            "metricInformation": GcpMarketplacePrivateOfferMetricInformation.from_dict(obj["metricInformation"]) if obj.get("metricInformation") is not None else None,
            "migrationMetadata": GcpMarketplacePrivateOfferMigrationMetadata.from_dict(obj["migrationMetadata"]) if obj.get("migrationMetadata") is not None else None,
            "name": obj.get("name"),
            "offerId": obj.get("offerId"),
            "offerSource": obj.get("offerSource"),
            "offerState": obj.get("offerState"),
            "offerTerm": GcpMarketplacePrivateOfferTerm.from_dict(obj["offerTerm"]) if obj.get("offerTerm") is not None else None,
            "offerTitle": obj.get("offerTitle"),
            "offerTitleAutoGenerated": obj.get("offerTitleAutoGenerated"),
            "paymentSchedule": obj.get("paymentSchedule"),
            "policies": obj.get("policies"),
            "priceModel": GcpMarketplacePrivateOfferPriceModel.from_dict(obj["priceModel"]) if obj.get("priceModel") is not None else None,
            "priceModelType": obj.get("priceModelType"),
            "providerCancellationInternalNote": obj.get("providerCancellationInternalNote"),
            "providerInfo": GcpMarketplacePrivateOfferProviderInfo.from_dict(obj["providerInfo"]) if obj.get("providerInfo") is not None else None,
            "providerInternalNote": obj.get("providerInternalNote"),
            "providerPublicNote": obj.get("providerPublicNote"),
            "purchaseChannel": GcpMarketplacePurchaseChannel.from_dict(obj["purchaseChannel"]) if obj.get("purchaseChannel") is not None else None,
            "purchaseTime": obj.get("purchaseTime"),
            "replacementMetadata": GcpMarketplacePrivateOfferReplacementMetadata.from_dict(obj["replacementMetadata"]) if obj.get("replacementMetadata") is not None else None,
            "resellerInfo": GcpMarketplaceResellerInfo.from_dict(obj["resellerInfo"]) if obj.get("resellerInfo") is not None else None,
            "serviceLevel": obj.get("serviceLevel"),
            "updateTime": obj.get("updateTime"),
            "useLegacyPartnerEula": obj.get("useLegacyPartnerEula"),
            "userLabels": obj.get("userLabels")
        })
        return _obj


