# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplacePrivateOfferCustomerInfo(BaseModel):
    """
    GcpMarketplacePrivateOfferCustomerInfo
    """ # noqa: E501
    address: Optional[StrictStr] = Field(default=None, description="The address of the customer")
    contact: Optional[StrictStr] = Field(default=None, description="The contact name of the customer")
    email: Optional[StrictStr] = Field(default=None, description="The email address of the customer")
    organization: Optional[StrictStr] = Field(default=None, description="The company name of the customer")
    unverified_billing_account: Optional[StrictStr] = Field(default=None, description="The GCP billing account ID of the customer", alias="unverifiedBillingAccount")
    __properties: ClassVar[List[str]] = ["address", "contact", "email", "organization", "unverifiedBillingAccount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOfferCustomerInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOfferCustomerInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address": obj.get("address"),
            "contact": obj.get("contact"),
            "email": obj.get("email"),
            "organization": obj.get("organization"),
            "unverifiedBillingAccount": obj.get("unverifiedBillingAccount")
        })
        return _obj


