# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_private_offer_price_model_discount import GcpMarketplacePrivateOfferPriceModelDiscount
from suger_sdk_python.models.gcp_period_duration import GcpPeriodDuration
from suger_sdk_python.models.gcp_price_value import GcpPriceValue
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplacePrivateOfferPriceModelCommitment(BaseModel):
    """
    GcpMarketplacePrivateOfferPriceModelCommitment
    """ # noqa: E501
    commitment_amount_per_period: Optional[GcpPriceValue] = Field(default=None, alias="commitmentAmountPerPeriod")
    discount: Optional[GcpMarketplacePrivateOfferPriceModelDiscount] = None
    period: Optional[GcpPeriodDuration] = None
    __properties: ClassVar[List[str]] = ["commitmentAmountPerPeriod", "discount", "period"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOfferPriceModelCommitment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of commitment_amount_per_period
        if self.commitment_amount_per_period:
            _dict['commitmentAmountPerPeriod'] = self.commitment_amount_per_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of period
        if self.period:
            _dict['period'] = self.period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOfferPriceModelCommitment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "commitmentAmountPerPeriod": GcpPriceValue.from_dict(obj["commitmentAmountPerPeriod"]) if obj.get("commitmentAmountPerPeriod") is not None else None,
            "discount": GcpMarketplacePrivateOfferPriceModelDiscount.from_dict(obj["discount"]) if obj.get("discount") is not None else None,
            "period": GcpPeriodDuration.from_dict(obj["period"]) if obj.get("period") is not None else None
        })
        return _obj


