# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_offer_start_policy import GcpMarketplaceOfferStartPolicy
from suger_sdk_python.models.gcp_marketplace_private_offer_term_duration_constraint import GcpMarketplacePrivateOfferTermDurationConstraint
from suger_sdk_python.models.gcp_period_duration import GcpPeriodDuration
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplacePrivateOfferTermTemplate(BaseModel):
    """
    GcpMarketplacePrivateOfferTermTemplate
    """ # noqa: E501
    enable_scheduled_start_times: Optional[StrictBool] = Field(default=None, alias="enableScheduledStartTimes")
    end_time: Optional[datetime] = Field(default=None, alias="endTime")
    payment_recurrence: Optional[StrictStr] = Field(default=None, alias="paymentRecurrence")
    start_policy: Optional[GcpMarketplaceOfferStartPolicy] = Field(default=None, alias="startPolicy")
    start_time: Optional[datetime] = Field(default=None, alias="startTime")
    term_duration: Optional[GcpPeriodDuration] = Field(default=None, alias="termDuration")
    term_duration_constraint: Optional[GcpMarketplacePrivateOfferTermDurationConstraint] = Field(default=None, alias="termDurationConstraint")
    __properties: ClassVar[List[str]] = ["enableScheduledStartTimes", "endTime", "paymentRecurrence", "startPolicy", "startTime", "termDuration", "termDurationConstraint"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOfferTermTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of term_duration
        if self.term_duration:
            _dict['termDuration'] = self.term_duration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of term_duration_constraint
        if self.term_duration_constraint:
            _dict['termDurationConstraint'] = self.term_duration_constraint.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplacePrivateOfferTermTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enableScheduledStartTimes": obj.get("enableScheduledStartTimes"),
            "endTime": obj.get("endTime"),
            "paymentRecurrence": obj.get("paymentRecurrence"),
            "startPolicy": obj.get("startPolicy"),
            "startTime": obj.get("startTime"),
            "termDuration": GcpPeriodDuration.from_dict(obj["termDuration"]) if obj.get("termDuration") is not None else None,
            "termDurationConstraint": GcpMarketplacePrivateOfferTermDurationConstraint.from_dict(obj["termDurationConstraint"]) if obj.get("termDurationConstraint") is not None else None
        })
        return _obj


