# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_product_derived_discovery_state import GcpMarketplaceProductDerivedDiscoveryState
from suger_sdk_python.models.gcp_marketplace_product_listing_spec import GcpMarketplaceProductListingSpec
from suger_sdk_python.models.gcp_marketplace_product_service_config import GcpMarketplaceProductServiceConfig
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceProduct(BaseModel):
    """
    GcpMarketplaceProduct
    """ # noqa: E501
    create_time: Optional[datetime] = Field(default=None, alias="createTime")
    derived_discovery_state: Optional[GcpMarketplaceProductDerivedDiscoveryState] = Field(default=None, alias="derivedDiscoveryState")
    id: Optional[StrictStr] = Field(default=None, description="Nullable, GCP Marketplace Product UUID")
    last_publish_time: Optional[datetime] = Field(default=None, alias="lastPublishTime")
    listing_spec: Optional[GcpMarketplaceProductListingSpec] = Field(default=None, alias="listingSpec")
    marketplace: Optional[StrictStr] = None
    name: Optional[StrictStr] = Field(default=None, description="In format of \"projects/{project-number}/listings/{product-name}.endpoints.{provider-id}.cloud.goog\"")
    revision_create_time: Optional[datetime] = Field(default=None, alias="revisionCreateTime")
    revision_id: Optional[StrictStr] = Field(default=None, alias="revisionId")
    service: Optional[StrictStr] = Field(default=None, description="In format of \"services/{product-name}.endpoints.{provider-id}.cloud.goog\"")
    service_config: Optional[GcpMarketplaceProductServiceConfig] = Field(default=None, alias="serviceConfig")
    validation_summary: Optional[Dict[str, Any]] = Field(default=None, description="TODO: add type", alias="validationSummary")
    __properties: ClassVar[List[str]] = ["createTime", "derivedDiscoveryState", "id", "lastPublishTime", "listingSpec", "marketplace", "name", "revisionCreateTime", "revisionId", "service", "serviceConfig", "validationSummary"]

    @field_validator('marketplace')
    def marketplace_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['marketplaces/google-cloud']):
            raise ValueError("must be one of enum values ('marketplaces/google-cloud')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceProduct from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of derived_discovery_state
        if self.derived_discovery_state:
            _dict['derivedDiscoveryState'] = self.derived_discovery_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of listing_spec
        if self.listing_spec:
            _dict['listingSpec'] = self.listing_spec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_config
        if self.service_config:
            _dict['serviceConfig'] = self.service_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceProduct from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createTime": obj.get("createTime"),
            "derivedDiscoveryState": GcpMarketplaceProductDerivedDiscoveryState.from_dict(obj["derivedDiscoveryState"]) if obj.get("derivedDiscoveryState") is not None else None,
            "id": obj.get("id"),
            "lastPublishTime": obj.get("lastPublishTime"),
            "listingSpec": GcpMarketplaceProductListingSpec.from_dict(obj["listingSpec"]) if obj.get("listingSpec") is not None else None,
            "marketplace": obj.get("marketplace"),
            "name": obj.get("name"),
            "revisionCreateTime": obj.get("revisionCreateTime"),
            "revisionId": obj.get("revisionId"),
            "service": obj.get("service"),
            "serviceConfig": GcpMarketplaceProductServiceConfig.from_dict(obj["serviceConfig"]) if obj.get("serviceConfig") is not None else None,
            "validationSummary": obj.get("validationSummary")
        })
        return _obj


