# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_price_tier import GcpPriceTier
from suger_sdk_python.models.value_type import ValueType
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceProductMeteringMetric(BaseModel):
    """
    GcpMarketplaceProductMeteringMetric
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="Description: A detailed description of the metric, which can be used in documentation.")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    display_unit: Optional[StrictStr] = Field(default=None, description="such as \"min\"", alias="displayUnit")
    display_unit_description: Optional[StrictStr] = Field(default=None, description="such as \"minute\"", alias="displayUnitDescription")
    id: Optional[StrictStr] = Field(default=None, description="The usage metering metric/dimension key, all in lower case with underscore. It is in format of \"{plan_id}_{usage_dimension_key}\". For example, \"basic_plan_storage\".")
    metric_kind: Optional[StrictStr] = Field(default=None, description="such as \"DELTA\"", alias="metricKind")
    name: Optional[StrictStr] = Field(default=None, description="Name: The resource name of the metric descriptor, in format of \"{productServiceName}/{plan_id}_{usage_dimension_key}\"")
    price_tiers: Optional[List[GcpPriceTier]] = Field(default=None, description="Price info of this usage metering metric. Only applicable for the default offer (plan) and private offer.", alias="priceTiers")
    reporting_unit: Optional[StrictStr] = Field(default=None, description="such as \"min\"", alias="reportingUnit")
    sku_id: Optional[StrictStr] = Field(default=None, description="The SKU ID of this usage metering metric. Applicable only in Private Offer.", alias="skuId")
    unit: Optional[StrictStr] = Field(default=None, description="such as \"min\"")
    value_type: Optional[ValueType] = Field(default=None, description="such as \"INT64\"", alias="valueType")
    __properties: ClassVar[List[str]] = ["description", "displayName", "displayUnit", "displayUnitDescription", "id", "metricKind", "name", "priceTiers", "reportingUnit", "skuId", "unit", "valueType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceProductMeteringMetric from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in price_tiers (list)
        _items = []
        if self.price_tiers:
            for _item_price_tiers in self.price_tiers:
                if _item_price_tiers:
                    _items.append(_item_price_tiers.to_dict())
            _dict['priceTiers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceProductMeteringMetric from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "displayName": obj.get("displayName"),
            "displayUnit": obj.get("displayUnit"),
            "displayUnitDescription": obj.get("displayUnitDescription"),
            "id": obj.get("id"),
            "metricKind": obj.get("metricKind"),
            "name": obj.get("name"),
            "priceTiers": [GcpPriceTier.from_dict(_item) for _item in obj["priceTiers"]] if obj.get("priceTiers") is not None else None,
            "reportingUnit": obj.get("reportingUnit"),
            "skuId": obj.get("skuId"),
            "unit": obj.get("unit"),
            "valueType": obj.get("valueType")
        })
        return _obj


