# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_price_model import GcpMarketplacePriceModel
from suger_sdk_python.models.gcp_marketplace_product_subscription_plan import GcpMarketplaceProductSubscriptionPlan
from suger_sdk_python.models.gcp_marketplace_product_usage_fee import GcpMarketplaceProductUsageFee
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceProductPriceInfo(BaseModel):
    """
    GcpMarketplaceProductPriceInfo
    """ # noqa: E501
    description: Optional[StrictStr] = None
    price_model: Optional[GcpMarketplacePriceModel] = Field(default=None, alias="priceModel")
    subscription_plans: Optional[List[GcpMarketplaceProductSubscriptionPlan]] = Field(default=None, description="Subscription Plan (Flat Commitment)", alias="subscriptionPlans")
    usage_fees: Optional[List[GcpMarketplaceProductUsageFee]] = Field(default=None, description="Usage Metering Dimension/Metric if available", alias="usageFees")
    __properties: ClassVar[List[str]] = ["description", "priceModel", "subscriptionPlans", "usageFees"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceProductPriceInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in subscription_plans (list)
        _items = []
        if self.subscription_plans:
            for _item_subscription_plans in self.subscription_plans:
                if _item_subscription_plans:
                    _items.append(_item_subscription_plans.to_dict())
            _dict['subscriptionPlans'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in usage_fees (list)
        _items = []
        if self.usage_fees:
            for _item_usage_fees in self.usage_fees:
                if _item_usage_fees:
                    _items.append(_item_usage_fees.to_dict())
            _dict['usageFees'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceProductPriceInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "priceModel": obj.get("priceModel"),
            "subscriptionPlans": [GcpMarketplaceProductSubscriptionPlan.from_dict(_item) for _item in obj["subscriptionPlans"]] if obj.get("subscriptionPlans") is not None else None,
            "usageFees": [GcpMarketplaceProductUsageFee.from_dict(_item) for _item in obj["usageFees"]] if obj.get("usageFees") is not None else None
        })
        return _obj


