# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_isv_info import GcpMarketplaceIsvInfo
from suger_sdk_python.models.gcp_marketplace_offer_template_policies import GcpMarketplaceOfferTemplatePolicies
from suger_sdk_python.models.gcp_marketplace_private_offer_term_template import GcpMarketplacePrivateOfferTermTemplate
from suger_sdk_python.models.gcp_marketplace_product_feature_value import GcpMarketplaceProductFeatureValue
from suger_sdk_python.models.gcp_marketplace_product_info import GcpMarketplaceProductInfo
from suger_sdk_python.models.gcp_marketplace_reseller_info import GcpMarketplaceResellerInfo
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_agreement_documents import GcpMarketplaceResellerPrivateOfferPlanAgreementDocuments
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_duration_config import GcpMarketplaceResellerPrivateOfferPlanDurationConfig
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_installment_timeline_template import GcpMarketplaceResellerPrivateOfferPlanInstallmentTimelineTemplate
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_margin import GcpMarketplaceResellerPrivateOfferPlanMargin
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_metainfo import GcpMarketplaceResellerPrivateOfferPlanMetainfo
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_price_model_template import GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplate
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_reuse_policy import GcpMarketplaceResellerPrivateOfferPlanReusePolicy
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_state import GcpMarketplaceResellerPrivateOfferPlanState
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_state_transition import GcpMarketplaceResellerPrivateOfferPlanStateTransition
from suger_sdk_python.models.gcp_marketplace_start_policy import GcpMarketplaceStartPolicy
from suger_sdk_python.models.payment_schedule_type import PaymentScheduleType
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceResellerPrivateOfferPlan(BaseModel):
    """
    GcpMarketplaceResellerPrivateOfferPlan
    """ # noqa: E501
    acceptance_deadline_time: Optional[datetime] = Field(default=None, alias="acceptanceDeadlineTime")
    agreement: Optional[StrictStr] = Field(default=None, description="The resource name of agreement(entitlement) In format of \"projects/{projectNumber}/agreements/{agreementId}\"")
    agreement_documents: Optional[GcpMarketplaceResellerPrivateOfferPlanAgreementDocuments] = Field(default=None, alias="agreementDocuments")
    amendment_context: Optional[Dict[str, Any]] = Field(default=None, alias="amendmentContext")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    duration_config: Optional[GcpMarketplaceResellerPrivateOfferPlanDurationConfig] = Field(default=None, alias="durationConfig")
    features: Optional[List[GcpMarketplaceProductFeatureValue]] = None
    installment_timeline_template: Optional[GcpMarketplaceResellerPrivateOfferPlanInstallmentTimelineTemplate] = Field(default=None, alias="installmentTimelineTemplate")
    isv_info: Optional[GcpMarketplaceIsvInfo] = Field(default=None, alias="isvInfo")
    margin: Optional[GcpMarketplaceResellerPrivateOfferPlanMargin] = None
    meta_info: Optional[GcpMarketplaceResellerPrivateOfferPlanMetainfo] = Field(default=None, alias="metaInfo")
    name: Optional[StrictStr] = Field(default=None, description="In format of \"projects/{projectNumber}/partnerAccounts/{partnerAccountId}/resellerPrivateOfferPlans/{resellerPrivateOfferPlanId}\"")
    offer_template_policies: Optional[GcpMarketplaceOfferTemplatePolicies] = Field(default=None, alias="offerTemplatePolicies")
    offer_term_template: Optional[GcpMarketplacePrivateOfferTermTemplate] = Field(default=None, alias="offerTermTemplate")
    payment_schedule: Optional[PaymentScheduleType] = Field(default=None, alias="paymentSchedule")
    price_model_template: Optional[GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplate] = Field(default=None, description="Nill if this reseller private offer plan has installmentTimelineTemplate (payment installments).", alias="priceModelTemplate")
    product_info: Optional[GcpMarketplaceProductInfo] = Field(default=None, alias="productInfo")
    replacement_metadata: Optional[Dict[str, Any]] = Field(default=None, alias="replacementMetadata")
    resell_offer_template: Optional[StrictStr] = Field(default=None, description="in format of \"resellOfferTemplates/{resellOfferTemplateId}\"", alias="resellOfferTemplate")
    reseller_info: Optional[GcpMarketplaceResellerInfo] = Field(default=None, alias="resellerInfo")
    reuse_policy: Optional[GcpMarketplaceResellerPrivateOfferPlanReusePolicy] = Field(default=None, alias="reusePolicy")
    start_policy: Optional[GcpMarketplaceStartPolicy] = Field(default=None, alias="startPolicy")
    state: Optional[GcpMarketplaceResellerPrivateOfferPlanState] = None
    state_transitions: Optional[List[GcpMarketplaceResellerPrivateOfferPlanStateTransition]] = Field(default=None, alias="stateTransitions")
    update_time: Optional[datetime] = Field(default=None, alias="updateTime")
    __properties: ClassVar[List[str]] = ["acceptanceDeadlineTime", "agreement", "agreementDocuments", "amendmentContext", "displayName", "durationConfig", "features", "installmentTimelineTemplate", "isvInfo", "margin", "metaInfo", "name", "offerTemplatePolicies", "offerTermTemplate", "paymentSchedule", "priceModelTemplate", "productInfo", "replacementMetadata", "resellOfferTemplate", "resellerInfo", "reusePolicy", "startPolicy", "state", "stateTransitions", "updateTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceResellerPrivateOfferPlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of agreement_documents
        if self.agreement_documents:
            _dict['agreementDocuments'] = self.agreement_documents.to_dict()
        # override the default output from pydantic by calling `to_dict()` of duration_config
        if self.duration_config:
            _dict['durationConfig'] = self.duration_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in features (list)
        _items = []
        if self.features:
            for _item_features in self.features:
                if _item_features:
                    _items.append(_item_features.to_dict())
            _dict['features'] = _items
        # override the default output from pydantic by calling `to_dict()` of installment_timeline_template
        if self.installment_timeline_template:
            _dict['installmentTimelineTemplate'] = self.installment_timeline_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of isv_info
        if self.isv_info:
            _dict['isvInfo'] = self.isv_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of margin
        if self.margin:
            _dict['margin'] = self.margin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meta_info
        if self.meta_info:
            _dict['metaInfo'] = self.meta_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of offer_template_policies
        if self.offer_template_policies:
            _dict['offerTemplatePolicies'] = self.offer_template_policies.to_dict()
        # override the default output from pydantic by calling `to_dict()` of offer_term_template
        if self.offer_term_template:
            _dict['offerTermTemplate'] = self.offer_term_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_model_template
        if self.price_model_template:
            _dict['priceModelTemplate'] = self.price_model_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of product_info
        if self.product_info:
            _dict['productInfo'] = self.product_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reseller_info
        if self.reseller_info:
            _dict['resellerInfo'] = self.reseller_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in state_transitions (list)
        _items = []
        if self.state_transitions:
            for _item_state_transitions in self.state_transitions:
                if _item_state_transitions:
                    _items.append(_item_state_transitions.to_dict())
            _dict['stateTransitions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceResellerPrivateOfferPlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptanceDeadlineTime": obj.get("acceptanceDeadlineTime"),
            "agreement": obj.get("agreement"),
            "agreementDocuments": GcpMarketplaceResellerPrivateOfferPlanAgreementDocuments.from_dict(obj["agreementDocuments"]) if obj.get("agreementDocuments") is not None else None,
            "amendmentContext": obj.get("amendmentContext"),
            "displayName": obj.get("displayName"),
            "durationConfig": GcpMarketplaceResellerPrivateOfferPlanDurationConfig.from_dict(obj["durationConfig"]) if obj.get("durationConfig") is not None else None,
            "features": [GcpMarketplaceProductFeatureValue.from_dict(_item) for _item in obj["features"]] if obj.get("features") is not None else None,
            "installmentTimelineTemplate": GcpMarketplaceResellerPrivateOfferPlanInstallmentTimelineTemplate.from_dict(obj["installmentTimelineTemplate"]) if obj.get("installmentTimelineTemplate") is not None else None,
            "isvInfo": GcpMarketplaceIsvInfo.from_dict(obj["isvInfo"]) if obj.get("isvInfo") is not None else None,
            "margin": GcpMarketplaceResellerPrivateOfferPlanMargin.from_dict(obj["margin"]) if obj.get("margin") is not None else None,
            "metaInfo": GcpMarketplaceResellerPrivateOfferPlanMetainfo.from_dict(obj["metaInfo"]) if obj.get("metaInfo") is not None else None,
            "name": obj.get("name"),
            "offerTemplatePolicies": GcpMarketplaceOfferTemplatePolicies.from_dict(obj["offerTemplatePolicies"]) if obj.get("offerTemplatePolicies") is not None else None,
            "offerTermTemplate": GcpMarketplacePrivateOfferTermTemplate.from_dict(obj["offerTermTemplate"]) if obj.get("offerTermTemplate") is not None else None,
            "paymentSchedule": obj.get("paymentSchedule"),
            "priceModelTemplate": GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplate.from_dict(obj["priceModelTemplate"]) if obj.get("priceModelTemplate") is not None else None,
            "productInfo": GcpMarketplaceProductInfo.from_dict(obj["productInfo"]) if obj.get("productInfo") is not None else None,
            "replacementMetadata": obj.get("replacementMetadata"),
            "resellOfferTemplate": obj.get("resellOfferTemplate"),
            "resellerInfo": GcpMarketplaceResellerInfo.from_dict(obj["resellerInfo"]) if obj.get("resellerInfo") is not None else None,
            "reusePolicy": obj.get("reusePolicy"),
            "startPolicy": obj.get("startPolicy"),
            "state": GcpMarketplaceResellerPrivateOfferPlanState.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "stateTransitions": [GcpMarketplaceResellerPrivateOfferPlanStateTransition.from_dict(_item) for _item in obj["stateTransitions"]] if obj.get("stateTransitions") is not None else None,
            "updateTime": obj.get("updateTime")
        })
        return _obj


