# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan_price_model_sku_representation import GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuRepresentation
from suger_sdk_python.models.gcp_price_model_discount_template import GcpPriceModelDiscountTemplate
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateOverage(BaseModel):
    """
    GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateOverage
    """ # noqa: E501
    discount_template: Optional[GcpPriceModelDiscountTemplate] = Field(default=None, alias="discountTemplate")
    sku_discount_templates: Optional[List[Dict[str, Any]]] = Field(default=None, alias="skuDiscountTemplates")
    sku_representation: Optional[GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuRepresentation] = Field(default=None, alias="skuRepresentation")
    __properties: ClassVar[List[str]] = ["discountTemplate", "skuDiscountTemplates", "skuRepresentation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateOverage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of discount_template
        if self.discount_template:
            _dict['discountTemplate'] = self.discount_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sku_representation
        if self.sku_representation:
            _dict['skuRepresentation'] = self.sku_representation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceResellerPrivateOfferPlanPriceModelTemplateOverage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "discountTemplate": GcpPriceModelDiscountTemplate.from_dict(obj["discountTemplate"]) if obj.get("discountTemplate") is not None else None,
            "skuDiscountTemplates": obj.get("skuDiscountTemplates"),
            "skuRepresentation": GcpMarketplaceResellerPrivateOfferPlanPriceModelSkuRepresentation.from_dict(obj["skuRepresentation"]) if obj.get("skuRepresentation") is not None else None
        })
        return _obj


