# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.gcp_marketplace_user_account_approval import GcpMarketplaceUserAccountApproval
from suger_sdk_python.models.gcp_marketplace_user_account_state import GcpMarketplaceUserAccountState
from suger_sdk_python.models.gcp_user_info import GcpUserInfo
from typing import Optional, Set
from typing_extensions import Self

class GcpMarketplaceUserAccount(BaseModel):
    """
    GcpMarketplaceUserAccount
    """ # noqa: E501
    approvals: Optional[List[GcpMarketplaceUserAccountApproval]] = Field(default=None, description="The approvals for this account, that are permitted or have been completed.")
    billing_account_id: Optional[StrictStr] = Field(default=None, description="The buyer's GCP billing account ID.", alias="billingAccountId")
    create_time: Optional[datetime] = Field(default=None, description="RFC3339 UTC timestamp", alias="createTime")
    id: Optional[StrictStr] = Field(default=None, description="GCP Marketplace User Account ID.")
    input_properties: Optional[List[StrictInt]] = Field(default=None, alias="inputProperties")
    name: Optional[StrictStr] = Field(default=None, description="The resource name of the account. Account names have the form providers/{provider_id}/accounts/{account_id}.")
    provider: Optional[StrictStr] = Field(default=None, description="The identifier of the service provider (SaaS Seller) that this account was created against.")
    state: Optional[GcpMarketplaceUserAccountState] = Field(default=None, description="The state of the account. An account might not be able to make a purchase if the billing account is suspended.")
    update_time: Optional[datetime] = Field(default=None, description="RFC3339 UTC timestamp", alias="updateTime")
    user_info: Optional[GcpUserInfo] = Field(default=None, alias="userInfo")
    __properties: ClassVar[List[str]] = ["approvals", "billingAccountId", "createTime", "id", "inputProperties", "name", "provider", "state", "updateTime", "userInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GcpMarketplaceUserAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in approvals (list)
        _items = []
        if self.approvals:
            for _item_approvals in self.approvals:
                if _item_approvals:
                    _items.append(_item_approvals.to_dict())
            _dict['approvals'] = _items
        # override the default output from pydantic by calling `to_dict()` of user_info
        if self.user_info:
            _dict['userInfo'] = self.user_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GcpMarketplaceUserAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "approvals": [GcpMarketplaceUserAccountApproval.from_dict(_item) for _item in obj["approvals"]] if obj.get("approvals") is not None else None,
            "billingAccountId": obj.get("billingAccountId"),
            "createTime": obj.get("createTime"),
            "id": obj.get("id"),
            "inputProperties": obj.get("inputProperties"),
            "name": obj.get("name"),
            "provider": obj.get("provider"),
            "state": obj.get("state"),
            "updateTime": obj.get("updateTime"),
            "userInfo": GcpUserInfo.from_dict(obj["userInfo"]) if obj.get("userInfo") is not None else None
        })
        return _obj


