# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage(BaseModel):
    """
    GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage
    """ # noqa: E501
    abandoned: Optional[Union[StrictFloat, StrictInt]] = None
    account_id: Optional[StrictStr] = Field(default=None, alias="accountID")
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    charges: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[StrictStr] = None
    due_vendor: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="dueVendor")
    entitlement_id: Optional[StrictStr] = Field(default=None, alias="entitlementID")
    google_entity: Optional[StrictStr] = Field(default=None, alias="googleEntity")
    insight_account_id: Optional[StrictStr] = Field(default=None, alias="insightAccountID")
    offer_id: Optional[StrictStr] = Field(default=None, alias="offerID")
    ordinal: Optional[StrictInt] = None
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    payment_schedule: Optional[StrictStr] = Field(default=None, alias="paymentSchedule")
    payment_type: Optional[StrictStr] = Field(default=None, alias="paymentType")
    prepay_credits: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="prepayCredits")
    product_id: Optional[StrictStr] = Field(default=None, alias="productID")
    refund_balance_deducted_this_month: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="refundBalanceDeductedThisMonth")
    refund_balance_outstanding: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="refundBalanceOutstanding")
    refund_reason: Optional[StrictStr] = Field(default=None, alias="refundReason")
    released: Optional[Union[StrictFloat, StrictInt]] = None
    report_date: Optional[StrictStr] = Field(default=None, alias="reportDate")
    resource: Optional[StrictStr] = None
    sku: Optional[StrictStr] = None
    trial_use: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="trialUse")
    unit: Optional[StrictStr] = None
    usage: Optional[Union[StrictFloat, StrictInt]] = None
    used_by: Optional[StrictStr] = Field(default=None, alias="usedBy")
    withheld: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["abandoned", "accountID", "buyerID", "charges", "currency", "dueVendor", "entitlementID", "googleEntity", "insightAccountID", "offerID", "ordinal", "organizationID", "paymentSchedule", "paymentType", "prepayCredits", "productID", "refundBalanceDeductedThisMonth", "refundBalanceOutstanding", "refundReason", "released", "reportDate", "resource", "sku", "trialUse", "unit", "usage", "usedBy", "withheld"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "abandoned": obj.get("abandoned"),
            "accountID": obj.get("accountID"),
            "buyerID": obj.get("buyerID"),
            "charges": obj.get("charges"),
            "currency": obj.get("currency"),
            "dueVendor": obj.get("dueVendor"),
            "entitlementID": obj.get("entitlementID"),
            "googleEntity": obj.get("googleEntity"),
            "insightAccountID": obj.get("insightAccountID"),
            "offerID": obj.get("offerID"),
            "ordinal": obj.get("ordinal"),
            "organizationID": obj.get("organizationID"),
            "paymentSchedule": obj.get("paymentSchedule"),
            "paymentType": obj.get("paymentType"),
            "prepayCredits": obj.get("prepayCredits"),
            "productID": obj.get("productID"),
            "refundBalanceDeductedThisMonth": obj.get("refundBalanceDeductedThisMonth"),
            "refundBalanceOutstanding": obj.get("refundBalanceOutstanding"),
            "refundReason": obj.get("refundReason"),
            "released": obj.get("released"),
            "reportDate": obj.get("reportDate"),
            "resource": obj.get("resource"),
            "sku": obj.get("sku"),
            "trialUse": obj.get("trialUse"),
            "unit": obj.get("unit"),
            "usage": obj.get("usage"),
            "usedBy": obj.get("usedBy"),
            "withheld": obj.get("withheld")
        })
        return _obj


