# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.notification_message import NotificationMessage
from typing import Optional, Set
from typing_extensions import Self

class ListNotificationMessagesResponse(BaseModel):
    """
    ListNotificationMessagesResponse
    """ # noqa: E501
    next_offset: Optional[StrictInt] = Field(default=None, description="The next offset to use in the next request to get the next page of notification messages. If this field is null, there are no more notification messages to get.", alias="nextOffset")
    notification_messages: Optional[List[NotificationMessage]] = Field(default=None, alias="notificationMessages")
    total_count: Optional[StrictInt] = Field(default=None, description="The total number of notification messages. Only available when the request is made with the first offset = 0.", alias="totalCount")
    __properties: ClassVar[List[str]] = ["nextOffset", "notificationMessages", "totalCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListNotificationMessagesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in notification_messages (list)
        _items = []
        if self.notification_messages:
            for _item_notification_messages in self.notification_messages:
                if _item_notification_messages:
                    _items.append(_item_notification_messages.to_dict())
            _dict['notificationMessages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListNotificationMessagesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nextOffset": obj.get("nextOffset"),
            "notificationMessages": [NotificationMessage.from_dict(_item) for _item in obj["notificationMessages"]] if obj.get("notificationMessages") is not None else None,
            "totalCount": obj.get("totalCount")
        })
        return _obj


