# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.types_usage_record import TypesUsageRecord
from suger_sdk_python.models.types_usage_record_result import TypesUsageRecordResult
from typing import Optional, Set
from typing_extensions import Self

class MarketplacemeteringBatchMeterUsageOutput(BaseModel):
    """
    MarketplacemeteringBatchMeterUsageOutput
    """ # noqa: E501
    result_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata pertaining to the operation's result.", alias="resultMetadata")
    results: Optional[List[TypesUsageRecordResult]] = Field(default=None, description="Contains all UsageRecords processed by BatchMeterUsage . These records were either honored by AWS Marketplace Metering Service or were invalid. Invalid records should be fixed before being resubmitted.")
    unprocessed_records: Optional[List[TypesUsageRecord]] = Field(default=None, description="Contains all UsageRecords that were not processed by BatchMeterUsage . This is a list of UsageRecords . You can retry the failed request by making another BatchMeterUsage call with this list as input in the BatchMeterUsageRequest .", alias="unprocessedRecords")
    __properties: ClassVar[List[str]] = ["resultMetadata", "results", "unprocessedRecords"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketplacemeteringBatchMeterUsageOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item_results in self.results:
                if _item_results:
                    _items.append(_item_results.to_dict())
            _dict['results'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in unprocessed_records (list)
        _items = []
        if self.unprocessed_records:
            for _item_unprocessed_records in self.unprocessed_records:
                if _item_unprocessed_records:
                    _items.append(_item_unprocessed_records.to_dict())
            _dict['unprocessedRecords'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketplacemeteringBatchMeterUsageOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resultMetadata": obj.get("resultMetadata"),
            "results": [TypesUsageRecordResult.from_dict(_item) for _item in obj["results"]] if obj.get("results") is not None else None,
            "unprocessedRecords": [TypesUsageRecord.from_dict(_item) for _item in obj["unprocessedRecords"]] if obj.get("unprocessedRecords") is not None else None
        })
        return _obj


